/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.AlternativeProductsHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.BPCPropertiesHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.CatalyticActivityCommentStructuredHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.CofactorCommentStructuredHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.CommentStatusHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.DiseaseCommentStructuredHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.InteractionCommentHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.MassSpectrometryHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.RnaEditingHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.SequenceCautionHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.SubcellularLocationHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.TextOnlyCommentHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.WebResourceHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.humdiseaselist.DiseaseIdListRetrieval;
import uk.ac.ebi.kraken.xml.uniprot.comment.subcell.SubcellLocations;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

class CommentHandlerFactory {
    private CommentFactory commentFactory;
    private ObjectFactory objectFactory;
    private EvidenceReferenceHandler evReferenceHandler;
    private CommentStatusHandler commentStatusHandler;
    private DiseaseIdListRetrieval diseaseIdListRetrieval;
    private SubcellLocations subcellLocations;

    CommentHandlerFactory() {
    }

    CommentHandlerFactory(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler evReferenceHandler, CommentStatusHandler commentStatusHandler, DiseaseIdListRetrieval diseaseIdListRetrieval, SubcellLocations subcellLocations) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        this.evReferenceHandler = evReferenceHandler;
        this.commentStatusHandler = commentStatusHandler;
        this.diseaseIdListRetrieval = diseaseIdListRetrieval;
        this.subcellLocations = subcellLocations;
    }

    public AlternativeProductsHandler buildAlternativeCommentHandler() {
        return new AlternativeProductsHandler(this.commentFactory, this.objectFactory, this.evReferenceHandler);
    }

    public BPCPropertiesHandler buildBPCPropertiesHandler() {
        return new BPCPropertiesHandler(this.commentFactory, this.objectFactory, this.evReferenceHandler);
    }

    public MassSpectrometryHandler buildMassSpectometryHandler() {
        return new MassSpectrometryHandler(this.commentFactory, this.objectFactory, this.evReferenceHandler);
    }

    public SubcellularLocationHandler buildSubcellularLocationHandler() {
        return new SubcellularLocationHandler(this.commentFactory, this.objectFactory, this.evReferenceHandler, this.commentStatusHandler, this.subcellLocations);
    }

    public SequenceCautionHandler buildSequenceCautionHandler() {
        return new SequenceCautionHandler(this.commentFactory, this.objectFactory, this.evReferenceHandler);
    }

    public RnaEditingHandler buildRnaEditingHandler() {
        return new RnaEditingHandler(this.commentFactory, this.objectFactory, this.evReferenceHandler);
    }

    public InteractionCommentHandler buildInteractionHandler() {
        return new InteractionCommentHandler(this.commentFactory, this.objectFactory, this.evReferenceHandler);
    }

    public TextOnlyCommentHandler buildTextOnlyCommentHandler() {
        return new TextOnlyCommentHandler(this.commentFactory, this.objectFactory, this.evReferenceHandler, this.commentStatusHandler);
    }

    public WebResourceHandler buildWebResourceCommentHandler() {
        return new WebResourceHandler(this.commentFactory, this.objectFactory, this.evReferenceHandler);
    }

    DiseaseCommentStructuredHandler buildDiseaseCommentStructuredHandler() {
        return new DiseaseCommentStructuredHandler(this.commentFactory, this.objectFactory, this.evReferenceHandler, this.diseaseIdListRetrieval);
    }

    CofactorCommentStructuredHandler buildCofactorCommentStructuredHandler() {
        return new CofactorCommentStructuredHandler(this.commentFactory, this.objectFactory, this.evReferenceHandler);
    }

    CatalyticActivityCommentStructuredHandler buildCatalyticActivityCommentStructuredHandler() {
        return new CatalyticActivityCommentStructuredHandler(this.commentFactory, this.objectFactory, this.evReferenceHandler);
    }

    public void setCommentFactory(CommentFactory commentFactory) {
        this.commentFactory = commentFactory;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setEvidenceReferenceHandler(EvidenceReferenceHandler evReferenceHandler) {
        this.evReferenceHandler = evReferenceHandler;
    }

    public GenericHandler buildCommentHandlerByType(CommentType commentType) {
        switch (commentType) {
            case INTERACTION: {
                return this.buildInteractionHandler();
            }
            case ALTERNATIVE_PRODUCTS: {
                return this.buildAlternativeCommentHandler();
            }
            case BIOPHYSICOCHEMICAL_PROPERTIES: {
                return this.buildBPCPropertiesHandler();
            }
            case MASS_SPECTROMETRY: {
                return this.buildMassSpectometryHandler();
            }
            case SUBCELLULAR_LOCATION: {
                return this.buildSubcellularLocationHandler();
            }
            case RNA_EDITING: {
                return this.buildRnaEditingHandler();
            }
            case SEQUENCE_CAUTION: {
                return this.buildSequenceCautionHandler();
            }
            case WEBRESOURCE: {
                return this.buildWebResourceCommentHandler();
            }
            case DISEASE: {
                return this.buildDiseaseCommentStructuredHandler();
            }
            case COFACTOR: {
                return this.buildCofactorCommentStructuredHandler();
            }
            case CATALYTIC_ACTIVITY: {
                return this.buildCatalyticActivityCommentStructuredHandler();
            }
        }
        return this.buildTextOnlyCommentHandler();
    }
}

