/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.citations.xrefs;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.CitationNewFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.AgricolaId;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationXrefs;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.DOI;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.PubMedId;
import uk.ac.ebi.kraken.model.factories.DefaultCitationNewFactory;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CitationType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.DbReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.citations.CitationItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.citations.xrefs.AgricolaStrategy;
import uk.ac.ebi.kraken.xml.uniprot.citations.xrefs.CitationXrefHandler;
import uk.ac.ebi.kraken.xml.uniprot.citations.xrefs.CitationXrefsStrategy;
import uk.ac.ebi.kraken.xml.uniprot.citations.xrefs.DoiStrategy;
import uk.ac.ebi.kraken.xml.uniprot.citations.xrefs.PubMedStrategy;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class CitationXrefsHandler
implements CitationXrefHandler {
    private final AgricolaStrategy agricolaStrategy;
    private final DoiStrategy doiStrategy;
    private final PubMedStrategy pubMedStrategy;
    private final List<CitationXrefsStrategy> xrefsCommands;

    public CitationXrefsHandler(CitationNewFactory citationFactory, ObjectFactory objectFactory, EvidenceReferenceHandler evidenceReferenceHandler) {
        CitationItemFactory itemFactory = new CitationItemFactory();
        itemFactory.setCitationFactory(citationFactory);
        itemFactory.setObjectFactory(objectFactory);
        itemFactory.setReferenceHandler(evidenceReferenceHandler);
        GenericHandler<PubMedId, String> pubMedIdHandler = itemFactory.buildPubMedIdHandler();
        GenericHandler<DOI, String> doiHandler = itemFactory.buildDOIHandler();
        GenericHandler<AgricolaId, String> agricolaIdHandler = itemFactory.buildAgricolaIdHandler();
        this.agricolaStrategy = new AgricolaStrategy(agricolaIdHandler, objectFactory);
        this.doiStrategy = new DoiStrategy(doiHandler, objectFactory);
        this.pubMedStrategy = new PubMedStrategy(pubMedIdHandler, objectFactory);
        this.xrefsCommands = new ArrayList<CitationXrefsStrategy>(4);
        this.xrefsCommands.add(this.pubMedStrategy);
        this.xrefsCommands.add(this.agricolaStrategy);
        this.xrefsCommands.add(this.doiStrategy);
    }

    @Override
    public CitationXrefs fromJAXB(List<DbReferenceType> XML) {
        CitationXrefs citationXrefs = DefaultCitationNewFactory.getInstance().buildCitationXrefs();
        if (XML != null && !XML.isEmpty()) {
            for (CitationXrefsStrategy xrefsCommand : this.xrefsCommands) {
                for (DbReferenceType referenceType : XML) {
                    xrefsCommand.fromJAXB(referenceType, citationXrefs);
                }
            }
            return citationXrefs;
        }
        return null;
    }

    @Override
    public void toJAXB(CitationType citationXML, CitationXrefs xrefs) {
        if (xrefs.hasPubmedId()) {
            citationXML.getDbReference().add(this.pubMedStrategy.toJAXB(xrefs));
        }
        if (xrefs.hasAgricolaId()) {
            citationXML.getDbReference().add(this.agricolaStrategy.toJAXB(xrefs));
        }
        if (xrefs.hasDOI()) {
            citationXML.getDbReference().add(this.doiStrategy.toJAXB(xrefs));
        }
    }
}

