/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.citations.common;

import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.CitationNewFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Author;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.AuthoringGroup;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationXrefs;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.PublicationDate;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Title;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CitationType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.NameListType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.GenericUpdater;
import uk.ac.ebi.kraken.xml.uniprot.citations.CitationItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.citations.common.AuthorAndConsortiumHandler;
import uk.ac.ebi.kraken.xml.uniprot.citations.xrefs.CitationXrefHandler;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class CommonCitationUpdater
implements GenericUpdater<Citation, CitationType> {
    private final ObjectFactory objectFactory;
    private final GenericHandler<Title, String> titleHandler;
    private final GenericHandler<PublicationDate, String> publicationDateHandler;
    private final AuthorAndConsortiumHandler<Author> authorsListHandler;
    private final AuthorAndConsortiumHandler<AuthoringGroup> authoringGroupListHandler;
    private final CitationXrefHandler citationXrefsHandler;

    public CommonCitationUpdater(ObjectFactory objectFactory, CitationNewFactory citationFactory, EvidenceReferenceHandler evidenceReferenceHandler) {
        this.objectFactory = objectFactory;
        CitationItemFactory itemFactory = new CitationItemFactory();
        itemFactory.setCitationFactory(citationFactory);
        itemFactory.setObjectFactory(objectFactory);
        itemFactory.setReferenceHandler(evidenceReferenceHandler);
        this.titleHandler = itemFactory.buildTitleHandler();
        this.publicationDateHandler = itemFactory.buildPublicationDateHandler();
        this.authorsListHandler = itemFactory.buildAuthorsListHandler();
        this.authoringGroupListHandler = itemFactory.buildAuthoringGroupListHandler();
        this.citationXrefsHandler = itemFactory.buildCitationXrefsHandler();
    }

    @Override
    public void fromXmlBinding(Citation citation, CitationType citationXML) {
        List<AuthoringGroup> authoringGroupList;
        List<Author> authorList;
        PublicationDate publicationDate;
        Title title;
        CitationXrefs xrefs = this.citationXrefsHandler.fromJAXB(citationXML.getDbReference());
        if (xrefs != null) {
            citation.setCitationsXrefs(xrefs);
        }
        if ((title = this.titleHandler.fromXmlBinding(citationXML.getTitle())) != null) {
            citation.setTitle(title);
        }
        if ((publicationDate = this.publicationDateHandler.fromXmlBinding(citationXML.getDate())) != null) {
            citation.setPublicationDate(publicationDate);
        }
        if ((authorList = this.authorsListHandler.fromJAXB(citationXML)) != null) {
            citation.setAuthors(authorList);
        }
        if ((authoringGroupList = this.authoringGroupListHandler.fromJAXB(citationXML)) != null) {
            citation.setAuthoringGroup(authoringGroupList);
        }
    }

    @Override
    public void toXmlBinding(CitationType citationXML, Citation citation) {
        if (citation.hasCitationXrefs()) {
            CitationXrefs xrefs = citation.getCitationXrefs();
            this.citationXrefsHandler.toJAXB(citationXML, xrefs);
        }
        citationXML.setTitle(this.titleHandler.toXmlBinding(citation.getTitle()));
        citationXML.setDate(this.publicationDateHandler.toXmlBinding(citation.getPublicationDate()));
        NameListType authorsAndConsortiumList = this.objectFactory.createNameListType();
        NameListType authorsList = this.authorsListHandler.toJAXB(citation);
        NameListType consortiumList = this.authoringGroupListHandler.toJAXB(citation);
        if (consortiumList != null) {
            authorsAndConsortiumList.getConsortiumOrPerson().addAll(consortiumList.getConsortiumOrPerson());
        }
        if (authorsList != null) {
            authorsAndConsortiumList.getConsortiumOrPerson().addAll(authorsList.getConsortiumOrPerson());
        }
        if (!authorsAndConsortiumList.getConsortiumOrPerson().isEmpty()) {
            citationXML.setAuthorList(authorsAndConsortiumList);
        }
    }
}

