/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniparc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import uk.ac.ebi.kraken.interfaces.factories.UniParcFactory;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcEntry;
import uk.ac.ebi.kraken.model.factories.DefaultUniParcFactory;
import uk.ac.ebi.kraken.xml.common.KrakenXMLIterator;
import uk.ac.ebi.kraken.xml.uniparc.UniParcXMLEntryIterator;

public class UniParcXMLParser {
    private UniParcFactory factory;

    public UniParcXMLParser() {
        this.initFactory();
    }

    public UniParcXMLParser(UniParcFactory factory) {
        this.factory = factory;
    }

    private void initFactory() {
        this.factory = DefaultUniParcFactory.getInstance();
    }

    public UniParcFactory getFactory() {
        return this.factory;
    }

    public void setFactory(UniParcFactory factory) {
        this.factory = factory;
    }

    public UniParcEntry parse(InputStream inputStream) throws IOException {
        UniParcEntry answer = null;
        UniParcXMLEntryIterator iterator = new UniParcXMLEntryIterator(this.factory, inputStream);
        if (iterator.hasNext()) {
            answer = (UniParcEntry)iterator.next();
        }
        return answer;
    }

    public UniParcEntry parse(String xmlEntryString) throws IOException {
        UniParcEntry answer = null;
        UniParcXMLEntryIterator iterator = new UniParcXMLEntryIterator(this.factory, new StringReader(xmlEntryString));
        if (iterator.hasNext()) {
            answer = (UniParcEntry)iterator.next();
        }
        return answer;
    }

    public KrakenXMLIterator<UniParcEntry> parseAll(InputStream inputStream) throws IOException {
        return new UniParcXMLEntryIterator(this.factory, inputStream);
    }

    public KrakenXMLIterator<UniParcEntry> parseAll(File file) throws IOException {
        return new UniParcXMLEntryIterator(this.factory, file);
    }

    public KrakenXMLIterator<UniParcEntry> parseAll(URL url) throws IOException {
        return new UniParcXMLEntryIterator(this.factory, url);
    }
}

