/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.thread;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.util.thread.FutureDescription;
import uk.ac.ebi.kraken.util.thread.ResultHandler;

public class Consumer<T>
extends Thread {
    private final BlockingQueue<FutureDescription<T>> queue;
    private final ResultHandler<T> handler;
    private final Timer timer;
    private final int reportInterval;
    private final Logger mtLogger = LoggerFactory.getLogger((String)"uk.ac.ebi.kraken.util.mt");
    private long taskCounter = 0L;
    private long failureCounter = 0L;
    private long successCounter = 0L;
    private static final String CONSUMER_THREAD_NAME = "ConsumerThread";

    Consumer(BlockingQueue<FutureDescription<T>> queue, ResultHandler<T> handler, int reportInterval) {
        this(queue, handler, reportInterval, CONSUMER_THREAD_NAME);
    }

    Consumer(BlockingQueue<FutureDescription<T>> queue, ResultHandler<T> handler, int reportInterval, String consumerName) {
        this.reportInterval = reportInterval;
        this.queue = queue;
        this.handler = handler;
        this.setName(consumerName);
        this.timer = new Timer("Progress Reporter", true);
    }

    private void checkQueue() throws InterruptedException {
        FutureDescription<T> take = this.queue.take();
        try {
            T t = take.getFuture().get();
            this.consumeResult(t);
            ++this.taskCounter;
            ++this.successCounter;
        }
        catch (ExecutionException e) {
            ++this.failureCounter;
            this.mtLogger.error("Exception when executing the task:" + take.getDescription());
            StringWriter stringWriter = new StringWriter();
            PrintWriter pw = new PrintWriter(stringWriter);
            e.printStackTrace(pw);
            this.mtLogger.error(stringWriter.toString());
        }
    }

    @Override
    public void run() {
        this.mtLogger.info("Consumer thread is to be started.");
        long interval = 60000 * this.reportInterval;
        this.timer.scheduleAtFixedRate(new TimerTask(){
            private int counter = 0;

            @Override
            public void run() {
                ++this.counter;
                String message = String.format("PROGRESS: In the last %d mins: %d tasks are processed. In total so far: %d success, %d failed, in %d mins. ", Consumer.this.reportInterval, Consumer.this.taskCounter, Consumer.this.successCounter, Consumer.this.failureCounter, this.counter * Consumer.this.reportInterval);
                Consumer.this.mtLogger.info(message);
                Consumer.this.taskCounter = 0L;
            }
        }, interval, interval);
        try {
            while (true) {
                if (!this.queue.isEmpty()) {
                    this.checkQueue();
                    continue;
                }
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            this.mtLogger.info("Consumer thread is interruppted");
            this.timer.cancel();
            this.mtLogger.info("Consumer thread has been stopped");
            return;
        }
    }

    private void consumeResult(T future) {
        this.handler.process(future);
    }
}

