/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.objectcounter;

public class CountedObject<T>
implements Comparable<T> {
    public static final int ORDER_DESCENDING = 1;
    public static final int ORDER_ASCENDING = 2;
    private int order = 2;
    private int count;
    private T obj;

    protected CountedObject(T obj, int value) {
        this(obj, value, 2);
    }

    protected CountedObject(T obj, int count, int order) {
        this.obj = obj;
        this.order = order;
        this.count = count;
    }

    public void setAscending() {
        this.order = 2;
    }

    public void setDescending() {
        this.order = 1;
    }

    public T getObject() {
        return this.obj;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public int compareTo(Object o) {
        if (!(o instanceof CountedObject)) {
            throw new ClassCastException();
        }
        CountedObject co = (CountedObject)o;
        if (this.order == 1) {
            if (co.count > this.count) {
                return 1;
            }
            if (co.count < this.count) {
                return -1;
            }
            int result = 1;
            if (this.obj instanceof Comparable) {
                result = -((Comparable)this.obj).compareTo(co.obj);
            }
            return result;
        }
        if (co.count < this.count) {
            return 1;
        }
        if (co.count > this.count) {
            return -1;
        }
        int result = 1;
        if (this.obj instanceof Comparable) {
            result = ((Comparable)this.obj).compareTo(co.obj);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CountedObject)) {
            return false;
        }
        CountedObject countedObject = (CountedObject)o;
        if (this.count != countedObject.count) {
            return false;
        }
        return this.obj.equals(countedObject.obj);
    }

    public int hashCode() {
        return this.obj.hashCode();
    }

    public String toString() {
        return this.obj.toString() + " (" + this.count + ")";
    }
}

