/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WgsUtil {
    public static final String WGS_REGEXP = "([A-Z]{4}|[A-Z]{6})(\\d{2})(\\d{6,9})";
    public static final String WGS_MASTER_REGEXP = "([A-Z]{4}|[A-Z]{6})(\\d{2})(0{6,9})";
    private static Pattern wgsAccession = Pattern.compile("([A-Z]{4}|[A-Z]{6})(\\d{2})(\\d{6,9})");
    private static Pattern wgsMasterAccession = Pattern.compile("([A-Z]{4}|[A-Z]{6})(\\d{2})(0{6,9})");

    public static String getWGSMasterAccession(String accession) {
        if (accession.length() < 12) {
            return accession;
        }
        Matcher matcher = wgsAccession.matcher(accession);
        matcher.find();
        return matcher.group(1) + matcher.group(2) + matcher.group(3).replaceAll("\\d", "0");
    }

    public static String getPrefix(String accession) {
        Matcher matcher = wgsAccession.matcher(accession);
        matcher.find();
        return matcher.group(1);
    }

    public static String getVersion(String accession) {
        Matcher matcher = wgsAccession.matcher(accession);
        matcher.find();
        return matcher.group(2);
    }

    public static String getCanonical(String accession) {
        if (accession.length() < 12) {
            return accession;
        }
        Matcher matcher = wgsAccession.matcher(accession);
        matcher.find();
        return matcher.group(1) + matcher.group(2);
    }

    public static boolean isWGSMaster(String accession) {
        Matcher matcher = wgsMasterAccession.matcher(accession);
        return matcher.matches();
    }

    public static boolean isWGS(String accession) {
        Matcher matcher = wgsAccession.matcher(accession);
        return matcher.matches();
    }
}

