/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class SpeclistCompressor {
    public static void main(String[] args) throws Exception {
        File speclist = new File("resources/speclist.txt");
        try (FileWriter fw = new FileWriter("resources/ambigous.txt");
             BufferedReader r = new BufferedReader(new FileReader(speclist));){
            String line = null;
            boolean inHeader = true;
            boolean inFooter = false;
            Organism current = null;
            while ((line = r.readLine()) != null) {
                if (line.startsWith("_____")) {
                    inHeader = false;
                    continue;
                }
                if (inHeader || inFooter) continue;
                if (line.equals("")) {
                    inFooter = true;
                    continue;
                }
                if (line.startsWith(" ")) {
                    if ((line = line.trim()).startsWith("C")) {
                        current.c = line.substring(2);
                        continue;
                    }
                    if (!line.startsWith("S")) continue;
                    current.s = line.substring(2);
                    continue;
                }
                if (current != null && current.isAmbigous()) {
                    fw.write(current.toString());
                    fw.write("\n");
                }
                current = new Organism();
                current.n = line.substring(line.lastIndexOf(61) + 1);
            }
            fw.flush();
        }
    }

    private static class Organism {
        private String n;
        private String c;
        private String s;

        private Organism() {
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.n);
            if (this.c != null) {
                result.append(" (");
                result.append(this.c);
                result.append(")");
            }
            if (this.s != null) {
                result.append(" (");
                result.append(this.s);
                result.append(")");
            }
            return result.toString();
        }

        public boolean isAmbigous() {
            return this.c == null && this.s != null;
        }
    }
}

