/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser;

import uk.ac.ebi.kraken.interfaces.uniprot.CommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Absorption;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsIsoform;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSequenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MaximumVelocity;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstant;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstantUnit;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.parser.translator.CommentTranslatorHelper;

public class CommentHelper {
    public static final String APPROXIMATION_SYMBOL = "~";
    public static final String NANOMETERS_SYMBOL = "nm";
    public static final String ALTERNATIVE_PROMOTER_XMLTAG = "alternative promoter";
    public static final String ALTERNATIVE_SPLICING_XMLTAG = "alternative splicing";
    public static final String ALTERNATIVE_INITIATION_XMLTAG = "alternative initiation";
    public static final String RIBOSOMAL_FRAME_XMLTAG = "ribosomal frameshifting";
    public static final String ALTERNATIVE_PROMOTER_FF = "Alternative promoter usage";
    public static final String ALTERNATIVE_SPLICING_FF = "Alternative splicing";
    public static final String ALTERNATIVE_INITIATION_FF = "Alternative initiation";
    public static final String RIBOSOMAL_FRAME_FF = "Ribosomal frameshifting";

    public static <T extends Comment> T translateToComment(String annotation, CommentType type) {
        return CommentTranslatorHelper.translate(annotation, type);
    }

    protected static String stripTrailingFullStop(String line) {
        if (line.endsWith(".")) {
            return line.substring(0, line.lastIndexOf(46));
        }
        return line;
    }

    public static String stripStatus(String line) {
        boolean isCommentStatusPresent = false;
        for (CommentStatus status : CommentStatus.values()) {
            if (!line.endsWith(status.getValue()) && !line.endsWith(status.getValue() + ".") && !line.endsWith(status.getValue() + ").") && !line.endsWith(status.getValue() + ")")) continue;
            isCommentStatusPresent = true;
            break;
        }
        if (isCommentStatusPresent) {
            return line.substring(0, line.lastIndexOf(40) - 1);
        }
        return line;
    }

    public static String stripBrokenEvidences(String line) {
        int index = line.indexOf(";{");
        while (index > 0) {
            int end = line.indexOf(125);
            while (end != line.length() - 1 && line.charAt(end + 1) == '{') {
                end = line.indexOf(125, end + 1);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(line.substring(0, index + 1));
            sb.append(line.substring(end + 1, line.length()));
            line = sb.toString();
            index = line.indexOf(";{");
        }
        return line;
    }

    public static void parseAbsortion(String xmlValueString, Absorption absorption) {
        int pos = 0;
        if (xmlValueString.contains(APPROXIMATION_SYMBOL)) {
            pos = 1;
            absorption.setApproximation(true);
        }
        int index = xmlValueString.indexOf(32);
        String number = xmlValueString.substring(pos, index);
        int numberMax = Integer.parseInt(number);
        absorption.setMax(numberMax);
    }

    public static String getXmlValueString(Absorption absorption) {
        StringBuilder sb = new StringBuilder();
        if (absorption.isApproximation()) {
            sb.append(APPROXIMATION_SYMBOL);
        }
        sb.append(absorption.getMax()).append(" ").append(NANOMETERS_SYMBOL);
        return sb.toString();
    }

    public static void parseMaximumVelocity(String xmlValue, MaximumVelocity maximumVelocity) {
        int pos1 = xmlValue.indexOf(32);
        int pos2 = xmlValue.indexOf(32, pos1 + 1);
        String velocityString = xmlValue.substring(0, pos1);
        String unitString = xmlValue.substring(pos1 + 1, pos2);
        String enzymeString = xmlValue.substring(pos2 + 1);
        maximumVelocity.setVelocity(Float.parseFloat(velocityString));
        maximumVelocity.setMaxVelocityUnit(DefaultCommentFactory.getInstance().buildMaxVelocityUnit(unitString));
        maximumVelocity.setEnzyme(DefaultCommentFactory.getInstance().buildEnzyme(enzymeString));
    }

    public static String createXMLStringMaximumVelocity(MaximumVelocity maximumVelocity) {
        StringBuilder sb = new StringBuilder();
        sb.append(maximumVelocity.getVelocity()).append(" ");
        sb.append(maximumVelocity.getMaxVelocityUnit().getValue()).append(" ");
        sb.append(maximumVelocity.getEnzyme().getValue());
        return sb.toString();
    }

    public static void parseMichaelisConstant(String xmlValueString, MichaelisConstant michaelisConstant) {
        int pos1 = xmlValueString.indexOf(32);
        int pos2 = xmlValueString.indexOf(32, pos1 + 1);
        int pos3 = xmlValueString.indexOf(32, pos2 + 1);
        String constantString = xmlValueString.substring(0, pos1);
        String unitString = xmlValueString.substring(pos1 + 1, pos2);
        String substrateString = xmlValueString.substring(pos3 + 1);
        michaelisConstant.setConstant(Float.parseFloat(constantString));
        michaelisConstant.setUnit(MichaelisConstantUnit.convert(unitString));
        michaelisConstant.setSubstrate(DefaultCommentFactory.getInstance().buildSubstrate(substrateString));
    }

    public static String createXMLStringMichaelisConstant(MichaelisConstant michaelisConstant) {
        StringBuilder sb = new StringBuilder();
        String numericalValue = michaelisConstant.getConstant() + "";
        if (numericalValue.matches("\\d*.0")) {
            numericalValue = numericalValue.replace(".0", "");
        }
        sb.append(numericalValue);
        sb.append(' ');
        sb.append(michaelisConstant.getUnit().toDisplayNameString()).append(" for ");
        sb.append(michaelisConstant.getSubstrate().getValue());
        return sb.toString();
    }

    public static String createSequenceIdString(AlternativeProductsIsoform isoform) {
        String aux = "";
        int i = 0;
        for (IsoformSequenceId sequenceId : isoform.getSequenceIds()) {
            aux = aux + sequenceId.getValue();
            if (++i >= isoform.getSequenceIds().size()) continue;
            aux = aux + " ";
        }
        return aux;
    }
}

