/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import uk.ac.ebi.kraken.interfaces.common.Value;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;

public class ValueList<T extends Value>
implements List<Value> {
    private List<String> originalList;

    public ValueList(List<String> originalList) {
        this.originalList = originalList;
    }

    @Override
    public int size() {
        return this.originalList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.originalList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Value) {
            return this.originalList.contains(((Value)o).getValue());
        }
        return false;
    }

    @Override
    public Iterator<Value> iterator() {
        return null;
    }

    private List<Value> convert() {
        ArrayList<Value> result = new ArrayList<Value>();
        for (String s : this.originalList) {
            result.add(DefaultUniProtFactory.getInstance().buildValue(s));
        }
        return result;
    }

    @Override
    public Object[] toArray() {
        return this.convert().toArray();
    }

    @Override
    public <Value> Value[] toArray(Value[] ts) {
        return this.convert().toArray(ts);
    }

    @Override
    public boolean add(Value value) {
        return this.originalList.add(value.getValue());
    }

    @Override
    public boolean remove(Object o) {
        return this.convert().remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.convert().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Value> values) {
        boolean result = false;
        for (Value value : values) {
            result = result || this.originalList.add(value.getValue());
        }
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Value> values) {
        boolean result = false;
        for (Value value : values) {
            this.originalList.add(index++, value.getValue());
            result = true;
        }
        return result;
    }

    public Collection<String> convert(Collection<?> c) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object o : c) {
            if (!(o instanceof Value)) continue;
            result.add(((Value)o).getValue());
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.originalList.removeAll(this.convert(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.originalList.retainAll(this.convert(c));
    }

    @Override
    public void clear() {
        this.originalList.clear();
    }

    @Override
    public Value get(int index) {
        return null;
    }

    @Override
    public Value set(int index, Value value) {
        return null;
    }

    @Override
    public void add(int index, Value value) {
    }

    @Override
    public Value remove(int index) {
        return null;
    }

    @Override
    public int indexOf(Object o) {
        return 0;
    }

    @Override
    public int lastIndexOf(Object o) {
        return 0;
    }

    @Override
    public ListIterator<Value> listIterator() {
        return null;
    }

    @Override
    public ListIterator<Value> listIterator(int index) {
        return null;
    }

    @Override
    public List<Value> subList(int fromIndex, int toIndex) {
        return null;
    }
}

