/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.evidences;

import java.util.Arrays;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceAttribute;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceCode;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultEvidenceFactory;
import uk.ac.ebi.kraken.model.util.EvidenceCodeGenerator;

public class EvidenceIdImpl
implements PersistentObject,
EvidenceId {
    private static final List<String> NOT_EVIDENCE_TYPES = Arrays.asList("PubMed", "Reference", "Ref");
    private static final List<EvidenceCode> MAPPED_ECO_CODES = Arrays.asList(EvidenceCode.ECO_0000312, EvidenceCode.ECO_0000250);
    private static final String ECO = "ECO";
    private static final EvidenceCodeGenerator codeGenerator = new EvidenceCodeGenerator();
    private static final long serialVersionUID = 1L;
    private String evidenceId = "";
    private long id;
    private EvidenceType evidenceType = EvidenceType.NOT_SPECIFIED;
    private EvidenceAttribute attribute = DefaultEvidenceFactory.getInstance().buildEvidenceAttribute();
    private EvidenceCode evidenceCode = EvidenceCode.NOT_SPECIFIED;
    private boolean useECOCode = true;
    private String typeValue = "";
    private boolean hasTypeValue = true;

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String getValue() {
        return this.evidenceId;
    }

    @Override
    public void setValue(String value) {
        if (value != null) {
            if (!value.equals(this.evidenceId)) {
                this.evidenceId = value;
                this.parseId();
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void parseId() {
        if (!this.evidenceId.startsWith(ECO)) {
            this.useECOCode = false;
            return;
        }
        this.useECOCode = true;
        this.hasTypeValue = true;
        this.evidenceType = EvidenceType.NOT_SPECIFIED;
        int index = this.evidenceId.indexOf(124);
        if (index != -1) {
            String code = this.evidenceId.substring(0, index);
            try {
                this.evidenceCode = EvidenceCode.typeOf(code);
                this.evidenceType = codeGenerator.convertToEvidenceType(this.evidenceCode);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                this.evidenceCode = EvidenceCode.NOT_SPECIFIED;
            }
            String tValue = this.evidenceId.substring(index + 1);
            index = tValue.indexOf(58);
            String attr = "";
            if (index != -1) {
                this.typeValue = tValue.substring(0, index);
                attr = tValue.substring(index + 1);
                try {
                    if (!NOT_EVIDENCE_TYPES.contains(this.typeValue) && !MAPPED_ECO_CODES.contains((Object)this.evidenceCode)) {
                        EvidenceType evidenceType1;
                        this.evidenceType = evidenceType1 = EvidenceType.typeOf(this.typeValue);
                    }
                }
                catch (Exception evidenceType1) {}
            } else {
                EvidenceType tempType = EvidenceType.NOT_SPECIFIED;
                try {
                    tempType = EvidenceType.typeOf(tValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (tempType == EvidenceType.NOT_SPECIFIED) {
                    this.hasTypeValue = false;
                    attr = tValue;
                } else {
                    this.evidenceType = tempType;
                    this.typeValue = this.evidenceType.getValue();
                }
            }
            this.attribute = DefaultEvidenceFactory.getInstance().buildEvidenceAttribute(attr);
        } else {
            try {
                this.evidenceCode = EvidenceCode.typeOf(this.evidenceId);
                this.evidenceType = codeGenerator.convertToEvidenceType(this.evidenceCode);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                this.evidenceCode = EvidenceCode.NOT_SPECIFIED;
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EvidenceIdImpl)) {
            return false;
        }
        EvidenceIdImpl evidenceId1 = (EvidenceIdImpl)o;
        return !(this.evidenceId != null ? !this.evidenceId.equals(evidenceId1.evidenceId) : evidenceId1.evidenceId != null);
    }

    public int hashCode() {
        return this.evidenceId != null ? this.evidenceId.hashCode() : 0;
    }

    public String toString() {
        return this.evidenceId;
    }

    @Override
    public EvidenceCode getEvidenceCode() {
        return this.evidenceCode;
    }

    @Override
    public EvidenceType getType() {
        return this.evidenceType;
    }

    @Override
    public EvidenceAttribute getAttribute() {
        return this.attribute;
    }

    @Override
    public int compareTo(EvidenceId o) {
        return this.evidenceId.compareToIgnoreCase(o.getValue());
    }

    @Override
    public boolean useECOCode() {
        return this.useECOCode;
    }

    @Override
    public String getTypeValue() {
        if (!this.hasTypeValue) {
            return "";
        }
        return this.typeValue;
    }
}

