/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.go;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.go.Go;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.go.GoEvidenceSource;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.go.GoEvidenceType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.go.GoId;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.go.GoTerm;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.go.OntologyType;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.uniprot.dbx.DatabaseCrossReferenceImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.go.GoEvidenceSourceImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.go.GoIdImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.go.GoTermImpl;

public class GoImpl
extends DatabaseCrossReferenceImpl
implements Go,
PersistentObject,
HasDbAccession {
    private long id;
    private final GoId goId = new GoIdImpl();
    private final GoEvidenceType goEvidenceType;
    private final GoTerm goTerm;
    private final GoEvidenceSource goEvidenceSource;
    private final OntologyType ontologyType;

    public GoImpl(DatabaseCrossReference toCopy) {
        super(toCopy);
        this.goId.setValue(toCopy.getPrimaryId().getValue());
        String description = toCopy.getDescription().getValue();
        this.goTerm = new GoTermImpl();
        if (!description.isEmpty()) {
            int index = description.indexOf(58);
            if (index != -1) {
                String type = description.substring(0, index + 1);
                String val = description.substring(index + 1);
                this.ontologyType = OntologyType.parseOntologyType(type);
                this.goTerm.setValue(val);
            } else {
                this.ontologyType = OntologyType.UNKNOWN;
            }
        } else {
            this.ontologyType = OntologyType.UNKNOWN;
        }
        String third = toCopy.getThird().getValue();
        this.goEvidenceSource = new GoEvidenceSourceImpl();
        if (!third.isEmpty()) {
            int index = third.indexOf(58);
            if (index != -1) {
                String type = third.substring(0, index);
                String val = third.substring(index + 1);
                this.goEvidenceType = GoEvidenceType.parseGoEvidenceType(type);
                this.goEvidenceSource.setValue(val);
            } else {
                this.goEvidenceType = GoEvidenceType.UNKNOWN;
            }
        } else {
            this.goEvidenceType = GoEvidenceType.UNKNOWN;
        }
    }

    @Override
    public String getDbAccession() {
        return this.getGoId().getValue();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public GoId getGoId() {
        return this.goId;
    }

    @Override
    public boolean hasGoId() {
        return !this.goId.getValue().equals("");
    }

    @Override
    public GoEvidenceType getGoEvidenceType() {
        return this.goEvidenceType;
    }

    @Override
    public GoTerm getGoTerm() {
        return this.goTerm;
    }

    @Override
    public boolean hasGoTerm() {
        return !this.goTerm.getValue().equals("");
    }

    @Override
    public GoEvidenceSource getGoEvidenceSource() {
        return this.goEvidenceSource;
    }

    @Override
    public boolean hasGoEvidenceSource() {
        return !this.goEvidenceSource.getValue().equals("");
    }

    @Override
    public OntologyType getOntologyType() {
        return this.ontologyType;
    }
}

