/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.Collection;
import java.util.Collections;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionCommentNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionType;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;

public class SequenceCautionCommentImpl
extends CommentImpl
implements SequenceCautionComment {
    private static final long serialVersionUID = -6798188542863644770L;
    private String sequence;
    private SequenceCautionCommentNote sequenceCautionCommentNote;
    private SequenceCautionType sequenceCautionType;

    @Override
    public String getSequence() {
        return this.sequence;
    }

    @Override
    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public SequenceCautionCommentImpl() {
        this.sequenceCautionCommentNote = DefaultUniProtFactory.getCommentFactory().buildSequenceCautionCommentNote("");
        this.sequence = "";
        this.sequenceCautionType = SequenceCautionType.UNKNOWN;
        this.setCommentType(CommentType.SEQUENCE_CAUTION);
    }

    public SequenceCautionCommentImpl(SequenceCautionComment copy) {
        super(copy);
        this.sequence = copy.getSequence();
        this.sequenceCautionCommentNote = copy.getNote();
        this.sequenceCautionType = copy.getType();
        this.setCommentType(CommentType.SEQUENCE_CAUTION);
    }

    @Override
    public boolean hasNote() {
        return this.sequenceCautionCommentNote != null && this.sequenceCautionCommentNote.getValue().length() > 0;
    }

    @Override
    public SequenceCautionCommentNote getNote() {
        return this.sequenceCautionCommentNote;
    }

    @Override
    public void setNote(SequenceCautionCommentNote note) {
        this.sequenceCautionCommentNote = note;
    }

    @Override
    public SequenceCautionType getType() {
        return this.sequenceCautionType;
    }

    @Override
    public void setType(SequenceCautionType note) {
        this.sequenceCautionType = note;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.sequence == null ? 0 : this.sequence.hashCode());
        result = 31 * result + (this.sequenceCautionCommentNote == null ? 0 : this.sequenceCautionCommentNote.hashCode());
        result = 31 * result + (this.sequenceCautionType == null ? 0 : this.sequenceCautionType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequenceCautionCommentImpl other = (SequenceCautionCommentImpl)obj;
        if (this.sequence == null ? other.sequence != null : !this.sequence.equals(other.sequence)) {
            return false;
        }
        if (this.sequenceCautionCommentNote == null ? other.sequenceCautionCommentNote != null : !this.sequenceCautionCommentNote.equals(other.sequenceCautionCommentNote)) {
            return false;
        }
        return this.sequenceCautionType == other.sequenceCautionType;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.sequence != null ? "Sequence=" + this.sequence + ";" : "");
        result.append(this.sequenceCautionType != null ? " Type=" + this.sequenceCautionType.toDisplayName() + ";" : "");
        result.append(this.sequenceCautionCommentNote != null && this.sequenceCautionCommentNote.getValue().length() > 0 ? " Note=" + this.sequenceCautionCommentNote.getValue() + ";" : "");
        return result.toString();
    }

    @Override
    public Collection<EvidenceId> collectEvidences() {
        return Collections.emptySet();
    }
}

