/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.citationsNew;

import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationTypeEnum;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Patent;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.PatentNumber;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultCitationNewFactory;
import uk.ac.ebi.kraken.model.uniprot.citationsNew.CitationImpl;

public class PatentImpl
extends CitationImpl
implements Patent,
PersistentObject {
    private PatentNumber patentNumber;
    private long id;

    public PatentImpl() {
        super(CitationTypeEnum.PATENT);
        this.patentNumber = DefaultCitationNewFactory.getInstance().buildPatentNumber();
    }

    public PatentImpl(Patent copy) {
        super(copy);
        this.patentNumber = DefaultCitationNewFactory.getInstance().buildPatentNumber(copy.getPatentNumber());
    }

    @Override
    public CitationTypeEnum getCitationType() {
        return CitationTypeEnum.PATENT;
    }

    @Override
    public PatentNumber getPatentNumber() {
        return this.patentNumber;
    }

    @Override
    public void setPatentNumber(PatentNumber patentNumber) {
        if (patentNumber == null) {
            throw new IllegalArgumentException();
        }
        this.patentNumber = patentNumber;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        PatentImpl patent = (PatentImpl)o;
        return !(this.patentNumber != null ? !this.patentNumber.equals(patent.patentNumber) : patent.patentNumber != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.patentNumber != null ? this.patentNumber.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "PatentImpl{patentNumber=" + this.patentNumber + '}';
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }
}

