/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.HasFreeText;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;

public class FreeTextImpl
implements PersistentObject,
HasFreeText {
    private static final long serialVersionUID = 1L;
    private List<EvidencedValue> texts;
    private long id = 0L;

    public FreeTextImpl() {
    }

    public FreeTextImpl(HasFreeText copy) {
        if (copy == null) {
            throw new IllegalArgumentException("Null value provided in the constructor");
        }
        this.texts = new ArrayList<EvidencedValue>();
        for (EvidencedValue val : copy.getTexts()) {
            this.texts.add(DefaultUniProtFactory.getInstance().buildEvidenceValue(val));
        }
    }

    @Override
    public List<EvidencedValue> getTexts() {
        if (this.texts == null) {
            this.texts = new ArrayList<EvidencedValue>();
        }
        return this.texts;
    }

    @Override
    public void setTexts(List<EvidencedValue> texts) {
        if (texts == null) {
            throw new IllegalArgumentException();
        }
        this.texts = texts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FreeTextImpl evValue = (FreeTextImpl)o;
        return !(this.texts != null && !this.texts.isEmpty() ? !this.texts.equals(evValue.texts) : evValue.texts != null && !evValue.texts.isEmpty());
    }

    public int hashCode() {
        int result = 0;
        result = this.texts != null && !this.texts.isEmpty() ? this.texts.hashCode() : 0;
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        boolean isFirst = true;
        for (EvidencedValue ev : this.getTexts()) {
            if (!isFirst) {
                result.append("\n");
            }
            result.append(ev.toString());
            isFirst = false;
        }
        return result.toString();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }
}

