/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;

public class EvidencedValueImpl
implements EvidencedValue,
PersistentObject {
    private static final long serialVersionUID = 1L;
    private String value = "";
    private List<EvidenceId> evidenceIds;
    private long id = 0L;

    public EvidencedValueImpl() {
    }

    public EvidencedValueImpl(EvidencedValue copy) {
        this();
        if (copy == null) {
            throw new IllegalArgumentException("Null value provided in the constructor");
        }
        if (copy.getValue() != null) {
            this.value = copy.getValue();
        }
        this.evidenceIds = new ArrayList<EvidenceId>();
        for (EvidenceId id : copy.getEvidenceIds()) {
            this.evidenceIds.add(DefaultUniProtFactory.getEvidenceFactory().buildEvidenceId(id.getValue()));
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.value = value;
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        if (this.evidenceIds == null) {
            this.evidenceIds = new ArrayList<EvidenceId>();
        }
        return this.evidenceIds;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidenceIds) {
        if (evidenceIds == null) {
            throw new IllegalArgumentException();
        }
        this.evidenceIds = evidenceIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvidencedValueImpl evValue = (EvidencedValueImpl)o;
        if (this.evidenceIds != null && !this.evidenceIds.isEmpty() ? !this.evidenceIds.equals(evValue.evidenceIds) : evValue.evidenceIds != null && !evValue.evidenceIds.isEmpty()) {
            return false;
        }
        return this.value.equals(evValue.value);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 29 * result + (this.evidenceIds != null && !this.evidenceIds.isEmpty() ? this.evidenceIds.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.value);
        if (this.evidenceIds != null && !this.evidenceIds.isEmpty()) {
            result.append("{");
            Iterator<EvidenceId> it = this.evidenceIds.iterator();
            while (it.hasNext()) {
                EvidenceId id = it.next();
                result.append(id);
                if (!it.hasNext()) continue;
                result.append(",");
            }
            result.append("}");
        }
        result.append("");
        return result.toString();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }
}

