/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.serialize;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import uk.ac.ebi.kraken.interfaces.interpro.InterProAc;
import uk.ac.ebi.kraken.interfaces.interpro.InterProMatch;
import uk.ac.ebi.kraken.interfaces.interpro.MethodAccession;
import uk.ac.ebi.kraken.interfaces.interpro.MethodName;
import uk.ac.ebi.kraken.interfaces.interpro.MethodType;
import uk.ac.ebi.kraken.interfaces.interpro.Status;
import uk.ac.ebi.kraken.interfaces.uniprot.PrimaryUniProtAccession;
import uk.ac.ebi.kraken.model.factories.DefaultInterProFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;

public class DefaultInterProMatchImplSerializer {
    public void writeObject(InterProMatch match, ObjectOutput out) throws IOException {
        out.writeInt(match.getFromPos());
        out.writeInt(match.getToPos());
        out.writeDouble(match.getScore());
        out.writeObject(match.getMethodName().getValue());
        out.writeObject(match.getUniProtAccession().getValue());
        out.writeObject(match.getMethodAccession().getValue());
        switch (match.getType()) {
            case GENE3D: {
                out.writeByte(1);
                break;
            }
            case PANTHER: {
                out.writeByte(2);
                break;
            }
            case PFAM: {
                out.writeByte(3);
                break;
            }
            case PIRSF: {
                out.writeByte(4);
                break;
            }
            case PREFILE: {
                out.writeByte(5);
                break;
            }
            case PRINTS: {
                out.writeByte(6);
                break;
            }
            case PRODOM: {
                out.writeByte(7);
                break;
            }
            case PROFILE: {
                out.writeByte(8);
                break;
            }
            case PROSITE: {
                out.writeByte(9);
                break;
            }
            case SMART: {
                out.writeByte(10);
                break;
            }
            case SSF: {
                out.writeByte(11);
                break;
            }
            case TIGRFAMs: {
                out.writeByte(12);
                break;
            }
            case UNKNOWN: {
                out.writeByte(13);
                break;
            }
            case HAMAP: {
                out.writeByte(14);
                break;
            }
        }
        switch (match.getStatus()) {
            case FALSE_NEGATIVE: {
                out.writeByte(1);
                break;
            }
            case FALSE_POSITIVE: {
                out.writeByte(2);
                break;
            }
            case MARGINAL: {
                out.writeByte(3);
                break;
            }
            case PARTIAL: {
                out.writeByte(4);
                break;
            }
            case TRUE_POSITIVE: {
                out.writeByte(5);
                break;
            }
            case UNKNOWN: {
                out.writeByte(6);
                break;
            }
        }
        out.writeInt(match.getInterProAcs().size());
        for (InterProAc ac : match.getInterProAcs()) {
            out.writeObject(ac.getValue());
        }
    }

    public void readObject(InterProMatch match, ObjectInput in) throws IOException, ClassNotFoundException {
        match.setFromPos(in.readInt());
        match.setToPos(in.readInt());
        match.setScore(in.readDouble());
        MethodName methodName = DefaultInterProFactory.getInstance().buildMethodName((String)in.readObject());
        match.setMethodName(methodName);
        PrimaryUniProtAccession uniProtAccession = DefaultUniProtFactory.getInstance().buildPrimaryUniProtAccession((String)in.readObject());
        match.setUniProtAccession(uniProtAccession);
        MethodAccession methodAccession = DefaultInterProFactory.getInstance().buildMethodAccession((String)in.readObject());
        match.setMethodAccession(methodAccession);
        byte b = in.readByte();
        MethodType type = null;
        switch (b) {
            case 1: {
                type = MethodType.GENE3D;
                break;
            }
            case 2: {
                type = MethodType.PANTHER;
                break;
            }
            case 3: {
                type = MethodType.PFAM;
                break;
            }
            case 4: {
                type = MethodType.PIRSF;
                break;
            }
            case 5: {
                type = MethodType.PREFILE;
                break;
            }
            case 6: {
                type = MethodType.PRINTS;
                break;
            }
            case 7: {
                type = MethodType.PRODOM;
                break;
            }
            case 8: {
                type = MethodType.PROFILE;
                break;
            }
            case 9: {
                type = MethodType.PROSITE;
                break;
            }
            case 10: {
                type = MethodType.SMART;
                break;
            }
            case 11: {
                type = MethodType.SSF;
                break;
            }
            case 12: {
                type = MethodType.TIGRFAMs;
                break;
            }
            case 13: {
                type = MethodType.UNKNOWN;
                break;
            }
            case 14: {
                type = MethodType.HAMAP;
            }
        }
        match.setType(type);
        byte c = in.readByte();
        Status status = null;
        switch (c) {
            case 1: {
                status = Status.FALSE_NEGATIVE;
                break;
            }
            case 2: {
                status = Status.FALSE_POSITIVE;
                break;
            }
            case 3: {
                status = Status.MARGINAL;
                break;
            }
            case 4: {
                status = Status.PARTIAL;
                break;
            }
            case 5: {
                status = Status.TRUE_POSITIVE;
                break;
            }
            case 6: {
                status = Status.UNKNOWN;
            }
        }
        match.setStatus(status);
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            String sac = (String)in.readObject();
            match.getInterProAcs().add(DefaultInterProFactory.getInstance().buildInterProAc(sac));
        }
    }
}

