/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.interpro;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.interpro.InterProAc;
import uk.ac.ebi.kraken.interfaces.interpro.InterProMatch;
import uk.ac.ebi.kraken.interfaces.interpro.MethodType;
import uk.ac.ebi.kraken.model.factories.DefaultInterProFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.interpro.InterProMatchImpl;

public class DefaultInterProMatchImpl
extends InterProMatchImpl {
    public DefaultInterProMatchImpl() {
        this.type = MethodType.UNKNOWN;
    }

    public DefaultInterProMatchImpl(InterProMatch copy) {
        this.fromPos = copy.getFromPos();
        this.toPos = copy.getToPos();
        this.score = copy.getScore();
        this.methodName = DefaultInterProFactory.getInstance().buildMethodName(copy.getMethodName());
        this.methodAccession = DefaultInterProFactory.getInstance().buildMethodAccession(copy.getMethodAccession());
        this.uniProtAccession = DefaultUniProtFactory.getInstance().buildPrimaryUniProtAccession(copy.getUniProtAccession().getValue());
        this.interProAcs = this.deepCopyInterProAcs(copy.getInterProAcs());
        this.status = copy.getStatus();
        this.type = copy.getType();
    }

    private List<InterProAc> deepCopyInterProAcs(List<InterProAc> interProAcsToCopy) {
        ArrayList<InterProAc> interProAcs = new ArrayList<InterProAc>(interProAcsToCopy.size());
        for (InterProAc interProAcToCopy : interProAcsToCopy) {
            interProAcs.add(DefaultInterProFactory.getInstance().buildInterProAc(interProAcToCopy));
        }
        return interProAcs;
    }

    public void setMethodType(MethodType type) {
        this.type = type;
    }

    @Override
    public MethodType getType() {
        return this.type;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DefaultInterProMatchImpl[");
        sb.append(this.methodAccession);
        sb.append(", ");
        sb.append((Object)this.type);
        sb.append(", ");
        sb.append(this.methodName);
        sb.append(", ");
        sb.append(this.fromPos);
        sb.append(", ");
        sb.append(this.toPos);
        sb.append(", ");
        sb.append(this.score);
        sb.append(", ");
        sb.append(", ");
        sb.append(this.interProAcs);
        sb.append(", ");
        sb.append((Object)this.status);
        sb.append(", ");
        sb.append((Object)this.type);
        sb.append("]");
        return sb.toString();
    }
}

