/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.uniprot;

public enum ProteinExistence {
    PROTEIN_LEVEL("Evidence at protein level", "1: Evidence at protein level"),
    TRANSCRIPT_LEVEL("Evidence at transcript level", "2: Evidence at transcript level"),
    HOMOLOGY("Inferred from homology", "3: Inferred from homology"),
    PREDICTED("Predicted", "4: Predicted"),
    UNCERTAIN("Uncertain", "5: Uncertain"),
    UNKNOWN("UNKNOWN", "UNKNOWN");

    private String value;
    private String displayName;

    public String getDisplayName() {
        return this.displayName;
    }

    private ProteinExistence(String type) {
        this.value = type;
        this.displayName = type;
    }

    private ProteinExistence(String type, String displayName) {
        this.value = type;
        this.displayName = displayName;
    }

    public String getValue() {
        return this.value.toString();
    }

    public static ProteinExistence typeOf(String value) {
        for (ProteinExistence proteinExistence : ProteinExistence.values()) {
            if (!proteinExistence.getValue().equalsIgnoreCase(value)) continue;
            return proteinExistence;
        }
        throw new IllegalArgumentException("the proteinExistence " + value + " doesn't exist");
    }

    public String toString() {
        return this.getValue();
    }
}

