/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.rlines;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.impl.LineConstant;
import uk.ac.ebi.kraken.ffwriter.line.impl.rlines.RLine;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Title;

public class RTLineBuilder
implements RLine<Title> {
    private static final String LINE_PREFIX = (Object)((Object)LineType.RT) + "   ";

    @Override
    public List<String> buildLine(Title f, boolean includeFFMarkup, boolean showEvidence) {
        if (f == null || f.getValue().length() == 0) {
            return new ArrayList<String>();
        }
        StringBuilder sb = new StringBuilder();
        if (includeFFMarkup) {
            sb.append(LINE_PREFIX);
        }
        sb.append("\"");
        sb.append(f.getValue());
        if (this.needAddStop(f.getValue())) {
            sb.append(".");
        }
        sb.append("\";");
        if (includeFFMarkup) {
            return FFLineWrapper.buildLines(sb.toString(), LineConstant.SEPS, LINE_PREFIX, 80);
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(sb.toString());
        return lines;
    }

    private boolean needAddStop(String title) {
        if (title == null || title.isEmpty()) {
            return false;
        }
        return !title.endsWith(".") && !title.endsWith("?") && !title.endsWith("!");
    }
}

