/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.ft;

import uk.ac.ebi.kraken.ffwriter.line.impl.ft.FTLineBuilderHelper;
import uk.ac.ebi.kraken.ffwriter.line.impl.ft.SimpleFeatureLineBuilder;
import uk.ac.ebi.kraken.interfaces.uniprot.features.CarbohydFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.CarbohydLinkType;

public class CarbohydFeatureLineBuilder
extends SimpleFeatureLineBuilder<CarbohydFeature> {
    @Override
    protected StringBuilder buildNoteString(CarbohydFeature feature) {
        boolean hasVal;
        StringBuilder sb = new StringBuilder();
        if (feature.getCarbohydLinkType() != CarbohydLinkType.UNKNOWN) {
            sb.append(feature.getCarbohydLinkType().getValue());
            sb.append(" ");
            sb.append(feature.getLinkedSugar().getValue());
        }
        StringBuilder descr = FTLineBuilderHelper.getDescriptionString(feature);
        StringBuilder status = FTLineBuilderHelper.getStatus(feature.getFeatureStatus());
        if (sb.length() > 0 && descr.length() > 0) {
            sb.append("; ");
            sb.append((CharSequence)descr);
        }
        boolean bl = hasVal = sb.length() > 0;
        if (status.length() > 0) {
            if (hasVal) {
                sb.append(" (");
            }
            sb.append((CharSequence)status);
            if (hasVal) {
                sb.append(")");
            }
        }
        return sb;
    }
}

