/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.cc;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.CCLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Interaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionType;

public class InteractionCCLineBuilder
extends CCLineBuilderAbstr<InteractionComment> {
    @Override
    protected List<String> buildCommentLines(InteractionComment comment, boolean includeFlatFileMarkings, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(this.buildStartWithMolecule(comment, includeFlatFileMarkings));
        for (Interaction act : comment.getInteractions()) {
            StringBuilder sb = new StringBuilder();
            if (includeFlatFileMarkings) {
                sb.append(this.linePrefix);
            }
            sb.append(this.buildLine(act));
            lines.add(sb.toString());
        }
        return this.addEvidences(lines, comment, showEvidence, this.linePrefix);
    }

    public String buildLine(Interaction act) {
        StringBuilder sb = new StringBuilder();
        sb.append(act.getFirstInteractant().getValue()).append("; ");
        sb.append(act.getSecondInteractant().getValue());
        if (act.getSecondInteractantParent() != null && !Strings.isNullOrEmpty((String)act.getSecondInteractantParent().getValue())) {
            sb.append(" [").append(act.getSecondInteractantParent().getValue()).append("]");
        }
        if (act.getInteractionGeneName() != null && !Strings.isNullOrEmpty((String)act.getInteractionGeneName().getValue())) {
            sb.append(": ");
            sb.append(act.getInteractionGeneName().getValue());
        }
        sb.append("; ");
        if (act.getInteractionType().equals((Object)InteractionType.XENO)) {
            sb.append("Xeno; ");
        }
        sb.append("NbExp=");
        sb.append(act.getNumberOfExperiments());
        sb.append("; IntAct");
        sb.append("=");
        sb.append(act.getFirstInteractor().getValue());
        if (act.getSecondInteractor() != null) {
            sb.append(", ");
            sb.append(act.getSecondInteractor().getValue());
        }
        sb.append(";");
        return sb.toString();
    }
}

