/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.cc;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.impl.LineConstant;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.CCLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsEvent;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsIsoform;

public class AlternativeProductsCCLineBuilder
extends CCLineBuilderAbstr<AlternativeProductsComment> {
    private static final String SEQUENCE = " Sequence=";
    private static final String ISO_ID = "IsoId=";
    private static final String SYNONYMS = " Synonyms=";
    private static final String COMMENT2 = "Comment=";
    private static final String NAMED_ISOFORMS = " Named isoforms=";
    private static final String EVENT2 = "Event=";

    @Override
    protected List<String> buildCommentLines(AlternativeProductsComment comment, boolean includeFlatFileMarkings, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(this.buildStartWithMolecule(comment, includeFlatFileMarkings));
        StringBuilder altProd = this.buildEvent(comment, includeFlatFileMarkings, showEvidence);
        lines.add(altProd.toString());
        lines.addAll(this.buildAltProdComment(comment, includeFlatFileMarkings, showEvidence));
        for (AlternativeProductsIsoform alternativeProductsIsoform : comment.getIsoforms()) {
            lines.addAll(this.buildIsoform(alternativeProductsIsoform, includeFlatFileMarkings, showEvidence));
        }
        return this.addEvidences(lines, comment, showEvidence, "CC         ");
    }

    private StringBuilder buildEvent(AlternativeProductsComment comment, boolean includeFlatFileMarkings, boolean showEvidence) {
        StringBuilder altProd = new StringBuilder();
        if (includeFlatFileMarkings) {
            altProd.append(this.linePrefix);
        }
        altProd.append(EVENT2);
        List<AlternativeProductsEvent> events = comment.getEvents();
        for (int iii = 0; iii < events.size(); ++iii) {
            AlternativeProductsEvent event = events.get(iii);
            altProd.append(event.getValue());
            if (iii < events.size() - 1) {
                altProd.append(", ");
                continue;
            }
            altProd.append(";");
        }
        if (!comment.getIsoforms().isEmpty()) {
            altProd.append(NAMED_ISOFORMS);
            altProd.append(comment.getIsoforms().size());
            altProd.append(";");
        }
        return altProd;
    }

    private List<String> buildAltProdComment(AlternativeProductsComment comment, boolean includeFlatFileMarkings, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        if (comment.getComment() != null && !comment.getComment().getTexts().isEmpty()) {
            StringBuilder asComment = new StringBuilder();
            if (includeFlatFileMarkings) {
                asComment.append("CC         ");
            }
            asComment.append(COMMENT2);
            String freeTextStr = this.buildFreeText(comment.getComment(), showEvidence, ".", ";");
            asComment.append(freeTextStr);
            if (includeFlatFileMarkings) {
                String[] seps = new String[]{" ", "-"};
                List<String> lls = FFLineWrapper.buildLines(asComment.toString(), seps, "CC         ", 80);
                lines.addAll(lls);
            } else {
                lines.add(asComment.toString());
            }
        }
        return lines;
    }

    private List<String> buildIsoformName(AlternativeProductsIsoform alternativeProductsIsoform, boolean includeFlatFileMarkings, boolean showEvidence) {
        StringBuilder altProd = new StringBuilder();
        if (includeFlatFileMarkings) {
            altProd.append(this.linePrefix);
        }
        altProd.append("Name=");
        altProd.append(alternativeProductsIsoform.getName().getValue());
        altProd = this.addEvidence(alternativeProductsIsoform.getName(), altProd, showEvidence, "");
        altProd.append(";");
        if (!alternativeProductsIsoform.getSynonyms().isEmpty()) {
            altProd.append(SYNONYMS);
            for (int i = 0; i < alternativeProductsIsoform.getSynonyms().size(); ++i) {
                altProd.append(alternativeProductsIsoform.getSynonyms().get(i).getValue());
                altProd = this.addEvidence(alternativeProductsIsoform.getSynonyms().get(i), altProd, showEvidence, "");
                this.addSeparator(altProd, ";", ", ", i == alternativeProductsIsoform.getSynonyms().size() - 1);
            }
        }
        ArrayList<String> lines = new ArrayList<String>();
        if (includeFlatFileMarkings) {
            List<String> lls = FFLineWrapper.buildLines(altProd, " ", this.linePrefix);
            lines.addAll(lls);
        } else {
            lines.add(altProd.toString());
        }
        return lines;
    }

    private StringBuilder addSeparator(StringBuilder sb, String sep1, String sep2, boolean isSep1) {
        if (isSep1) {
            sb.append(sep1);
        } else {
            sb.append(sep2);
        }
        return sb;
    }

    private List<String> buildIsoformId(AlternativeProductsIsoform alternativeProductsIsoform, boolean includeFlatFileMarkings, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        if (alternativeProductsIsoform.getIds().isEmpty()) {
            return lines;
        }
        StringBuilder isoform = new StringBuilder();
        if (includeFlatFileMarkings) {
            isoform.append("CC         ");
        }
        isoform.append(ISO_ID);
        for (int i = 0; i < alternativeProductsIsoform.getIds().size(); ++i) {
            isoform.append(alternativeProductsIsoform.getIds().get(i).getValue());
            this.addSeparator(isoform, ";", ", ", i == alternativeProductsIsoform.getIds().size() - 1);
        }
        isoform.append(SEQUENCE);
        int space = isoform.length();
        if (!alternativeProductsIsoform.getSequenceIds().isEmpty()) {
            for (int i = 0; i < alternativeProductsIsoform.getSequenceIds().size(); ++i) {
                isoform.append(alternativeProductsIsoform.getSequenceIds().get(i).getValue());
                this.addSeparator(isoform, ";", ", ", i == alternativeProductsIsoform.getSequenceIds().size() - 1);
            }
        } else {
            String status = alternativeProductsIsoform.getIsoformSequenceStatus().getValue();
            status = status.substring(0, 1).toUpperCase() + status.substring(1);
            isoform.append(status);
            isoform.append(";");
        }
        if (isoform.length() > 0) {
            if (includeFlatFileMarkings) {
                String prev = "CC                          ";
                while (prev.length() < space) {
                    prev = prev + " ";
                }
                List<String> lls = FFLineWrapper.buildLines(isoform.toString(), LineConstant.SEPS, prev, 80);
                lines.addAll(lls);
            } else {
                lines.add(isoform.toString());
            }
        }
        return lines;
    }

    private List<String> buildIsoformNote(AlternativeProductsIsoform alternativeProductsIsoform, boolean includeFlatFileMarkings, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        if (!alternativeProductsIsoform.hasNote()) {
            return lines;
        }
        StringBuilder asComment = new StringBuilder();
        if (includeFlatFileMarkings) {
            asComment.append("CC         ");
        }
        asComment.append("Note=");
        String freeTextStr = this.buildFreeText(alternativeProductsIsoform.getNote(), showEvidence, ".", ";");
        asComment.append(freeTextStr);
        if (includeFlatFileMarkings) {
            List<String> lls = FFLineWrapper.buildLines(asComment.toString(), LineConstant.SEPS, "CC         ", 80);
            lines.addAll(lls);
        } else {
            lines.add(asComment.toString());
        }
        return lines;
    }

    private List<String> buildIsoform(AlternativeProductsIsoform alternativeProductsIsoform, boolean includeFlatFileMarkings, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        List<String> nameLines = this.buildIsoformName(alternativeProductsIsoform, includeFlatFileMarkings, showEvidence);
        List<String> isoformLines = this.buildIsoformId(alternativeProductsIsoform, includeFlatFileMarkings, showEvidence);
        List<String> noteLines = this.buildIsoformNote(alternativeProductsIsoform, includeFlatFileMarkings, showEvidence);
        lines.addAll(nameLines);
        lines.addAll(isoformLines);
        lines.addAll(noteLines);
        return lines;
    }
}

