/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl;

import java.util.ArrayList;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;

public class IDLineBuilder
extends FFLineBuilderAbstr<UniProtEntry>
implements FFLineBuilder<UniProtEntry> {
    private static final String AA = "AA";
    private static final String REVIEWED = "Reviewed";
    private static final String UNREVIEWED = "Unreviewed";
    private static final char SINGLE_SPACE = ' ';
    private static final int UNREVIEWED_EXTRA_SPACE = 10;
    private static final int REVIEWED_EXTRA_SPACE = 12;
    private static final int ID_LENGTH = 29;

    public IDLineBuilder() {
        super(LineType.ID);
    }

    @Override
    public String buildString(UniProtEntry f) {
        return this.export(f).toString();
    }

    @Override
    public String buildStringWithEvidence(UniProtEntry f) {
        return this.export(f).toString();
    }

    @Override
    protected FFLine buildLine(UniProtEntry f, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(this.export(f).toString());
        return FFLines.create(lines);
    }

    private StringBuilder export(UniProtEntry entry) {
        StringBuilder sb = new StringBuilder();
        switch (entry.getType()) {
            case SWISSPROT: {
                sb.append((CharSequence)this.buildIdLine(entry.getUniProtId().getValue(), entry.getSequence().getLength(), REVIEWED, 12));
                break;
            }
            case TREMBL: {
                sb.append((CharSequence)this.buildIdLine(entry.getUniProtId().getValue(), entry.getSequence().getLength(), UNREVIEWED, 10));
                break;
            }
            case UNKNOWN: {
                throw new IllegalArgumentException();
            }
        }
        return sb;
    }

    private StringBuilder buildIdLine(String uniprotId, int seqLength, String reviewType, int extraSpace) {
        int lengthlength;
        StringBuilder sb = new StringBuilder();
        sb.append(this.linePrefix);
        sb.append(uniprotId);
        for (int iii = sb.length(); iii < 29; ++iii) {
            sb.append(' ');
        }
        sb.append(reviewType).append(";");
        for (int iii = lengthlength = Integer.valueOf(seqLength).toString().length(); iii < extraSpace; ++iii) {
            sb.append(' ');
        }
        sb.append(seqLength);
        sb.append(' ');
        sb.append(AA);
        sb.append(".");
        return sb;
    }
}

