/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.sapp.execution;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import org.sing_group.seda.bedtools.execution.BedToolsBinariesExecutor;
import org.sing_group.seda.comparator.SequenceComparator;
import org.sing_group.seda.core.filtering.SequenceNameHeaderMatcher;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.SequenceTarget;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupDataset;
import org.sing_group.seda.io.FastaWriter;
import org.sing_group.seda.sapp.datatype.SappCodon;
import org.sing_group.seda.sapp.datatype.SappSpecies;
import org.sing_group.seda.sapp.execution.SappBinariesExecutor;
import org.sing_group.seda.sapp.execution.SappGff3Parser;
import org.sing_group.seda.transformation.dataset.ComposedSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.ConcatenateSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.sequence.ChangePropertiesSequenceTransformation;
import org.sing_group.seda.transformation.sequencesgroup.ComposedSequencesGroupTransformation;
import org.sing_group.seda.transformation.sequencesgroup.SequencesGroupSortTransformation;

public class SappAnnotationPipeline {
    private final DatatypeFactory factory;
    private final SappBinariesExecutor sappBinariesExecutor;
    private final BedToolsBinariesExecutor bedToolsBinariesExecutor;
    private final SappSpecies sappSpecies;
    private final SappCodon sappCodon;

    public SappAnnotationPipeline(SappBinariesExecutor sappBinariesExecutor, BedToolsBinariesExecutor bedToolsBinariesExecutor, SappCodon sappCodon, SappSpecies sappSpecies) {
        this(DatatypeFactory.getDefaultDatatypeFactory(), sappBinariesExecutor, bedToolsBinariesExecutor, sappCodon, sappSpecies);
    }

    public SappAnnotationPipeline(DatatypeFactory factory, SappBinariesExecutor sappBinariesExecutor, BedToolsBinariesExecutor bedToolsBinariesExecutor, SappCodon sappCodon, SappSpecies sappSpecies) {
        this.factory = factory;
        this.sappBinariesExecutor = sappBinariesExecutor;
        this.bedToolsBinariesExecutor = bedToolsBinariesExecutor;
        this.sappSpecies = sappSpecies;
        this.sappCodon = sappCodon;
    }

    public void annotate(File inputFasta, File outputFasta) throws IOException, InterruptedException {
        Path sappAnnotationDirectory = Files.createTempDirectory("seda_sapp_annotation", new FileAttribute[0]);
        Path convertedFastaFile = sappAnnotationDirectory.resolve(inputFasta.getName() + ".hdt");
        this.sappBinariesExecutor.fasta2hdt(inputFasta, convertedFastaFile.toFile(), "sample_identifier", this.sappCodon, this.sappSpecies, "-genome -chromosome");
        Path augustusResultFile = sappAnnotationDirectory.resolve(inputFasta.getName() + "_augustus.hdt");
        this.sappBinariesExecutor.augustus(convertedFastaFile.toFile(), augustusResultFile.toFile(), this.sappCodon, this.sappSpecies);
        Path bedToolsInputBedFile = sappAnnotationDirectory.resolve(convertedFastaFile.toFile().getName() + ".gff3");
        Path bedToolsFilteredInputBedFile = sappAnnotationDirectory.resolve(convertedFastaFile.toFile().getName() + ".gff3.filtered");
        new SappGff3Parser(bedToolsInputBedFile.toFile()).extractCdsRegionsByGeneToFile(bedToolsFilteredInputBedFile.toFile());
        Path bedToolsInputFastaFile = sappAnnotationDirectory.resolve(convertedFastaFile.toFile().getName() + ".fasta");
        Path bedToolsOutputFastaFile = sappAnnotationDirectory.resolve(bedToolsInputBedFile.toFile().getName() + ".fasta");
        this.bedToolsBinariesExecutor.getFasta(bedToolsInputFastaFile.toFile(), bedToolsFilteredInputBedFile.toFile(), bedToolsOutputFastaFile.toFile(), "-nameOnly");
        Path bedToolsConcatenatedFastaFile = sappAnnotationDirectory.resolve(bedToolsOutputFastaFile.toFile().getName() + ".concatenated");
        FastaWriter.writeFasta(bedToolsConcatenatedFastaFile, SappAnnotationPipeline.concatenateSequences(bedToolsOutputFastaFile, this.factory).getSequences());
        Files.move(bedToolsConcatenatedFastaFile, outputFasta.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private static SequencesGroup concatenateSequences(Path fasta, DatatypeFactory factory) {
        HashMap<String, Object> sequencePropertiesMap = new HashMap<String, Object>();
        sequencePropertiesMap.put("chain.columns", 80);
        ChangePropertiesSequenceTransformation transformation = new ChangePropertiesSequenceTransformation(factory, sequencePropertiesMap);
        SequencesGroupDataset dataset = SequencesGroupDatasetTransformation.concat(new ConcatenateSequencesGroupDatasetTransformation("concatenaded", new SequenceNameHeaderMatcher(), false), new ComposedSequencesGroupDatasetTransformation(new ComposedSequencesGroupTransformation(transformation), new SequencesGroupSortTransformation(SequenceComparator.ALPHABETICAL.getComparator(SequenceTarget.HEADER), false, factory))).transform(factory.newSequencesGroupDataset(factory.newSequencesGroup(fasta)));
        return dataset.getSequencesGroups().findFirst().get();
    }
}

