/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.input.tree;

import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class PathCheckTreeSelectionModel
extends DefaultTreeSelectionModel {
    private static final long serialVersionUID = 1L;

    private boolean canPathBeAdded(TreePath treePath) {
        return ((DefaultMutableTreeNode)treePath.getLastPathComponent()).isLeaf();
    }

    private TreePath[] getFilteredPaths(TreePath[] paths) {
        ArrayList<TreePath> returnedPaths = new ArrayList<TreePath>(paths.length);
        for (TreePath treePath : paths) {
            if (!this.canPathBeAdded(treePath)) continue;
            returnedPaths.add(treePath);
        }
        return returnedPaths.toArray(new TreePath[returnedPaths.size()]);
    }

    @Override
    public void setSelectionPath(TreePath path) {
        if (this.canPathBeAdded(path)) {
            super.setSelectionPath(path);
        }
    }

    @Override
    public void setSelectionPaths(TreePath[] paths) {
        paths = this.getFilteredPaths(paths);
        super.setSelectionPaths(paths);
    }

    @Override
    public void addSelectionPath(TreePath path) {
        if (this.canPathBeAdded(path)) {
            super.addSelectionPath(path);
        }
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
        paths = this.getFilteredPaths(paths);
        super.addSelectionPaths(paths);
    }
}

