/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.input.tree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import org.sing_group.gc4s.utilities.JTreeUtils;
import org.sing_group.gc4s.utilities.builder.JButtonBuilder;

public class JTreeSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_CHOOSE_BUTTON_LABEL = "Choose";
    private static final boolean DEFAULT_CLOSE_POPUP_TREE_SELECTION = false;
    private static final boolean DEFAULT_BUTTON_CLOSE_VISIBLE = true;
    private static final boolean DEFAULT_BUTTON_EXPAND_ALL_VISIBLE = true;
    private static final boolean DEFAULT_BUTTON_COLLAPSE_ALL_VISIBLE = true;
    private JTree tree;
    private JLabel selectionLabel;
    private JTreePopupMenu popupMenu;
    private String chooseButtonLabel;
    private JButton chooseButton;
    private boolean closePopupOnTreeSelection;
    private boolean closeButtonVisible;
    private boolean expandAllButtonVisible;
    private boolean collapseAllButtonVisible;

    public JTreeSelectionPanel(JTree tree) {
        this(tree, DEFAULT_CHOOSE_BUTTON_LABEL, false, true, true, true);
    }

    public JTreeSelectionPanel(JTree tree, String chooseButtonLabel, boolean closePopupOnTreeSelection, boolean closeButtonVisible, boolean expandAllButtonVisible, boolean collapseAllButtonVisible) {
        this.tree = tree;
        this.chooseButtonLabel = chooseButtonLabel;
        this.closePopupOnTreeSelection = closePopupOnTreeSelection;
        this.closeButtonVisible = closeButtonVisible;
        this.expandAllButtonVisible = expandAllButtonVisible;
        this.collapseAllButtonVisible = collapseAllButtonVisible;
        this.init();
        this.tree.getSelectionModel().addTreeSelectionListener(this::treeValueChanged);
    }

    private void init() {
        this.popupMenu = new JTreePopupMenu(this.tree, this.closeButtonVisible, this.expandAllButtonVisible, this.collapseAllButtonVisible);
        this.setLayout(new BorderLayout());
        this.add(this.getChooseButton(), "West");
        this.add((Component)this.getSelectionLabel(), "Center");
    }

    private Component getChooseButton() {
        if (this.chooseButton == null) {
            this.chooseButton = JButtonBuilder.newJButtonBuilder().withText(this.chooseButtonLabel).thatDoes(this.getChooseButtonAction()).build();
        }
        return this.chooseButton;
    }

    private Action getChooseButtonAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JTreeSelectionPanel.this.chooseButtonAction();
            }
        };
    }

    private void chooseButtonAction() {
        this.popupMenu.show(this.chooseButton, this.chooseButton.getX(), this.chooseButton.getY());
        this.popupMenu.pack();
    }

    public JLabel getSelectionLabel() {
        if (this.selectionLabel == null) {
            this.selectionLabel = new JLabel(this.getCurrentSelection());
            this.selectionLabel.setMinimumSize(this.getSelectionLabelMinimumSize());
            this.selectionLabel.setPreferredSize(this.getSelectionLabelMinimumSize());
            this.selectionLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 5));
            this.selectionLabel.setFont(this.getSelectionLabelFont());
        }
        return this.selectionLabel;
    }

    protected Font getSelectionLabelFont() {
        return new JLabel().getFont();
    }

    protected Dimension getSelectionLabelMinimumSize() {
        return new Dimension(150, 30);
    }

    private String getCurrentSelection() {
        if (this.tree.getSelectionModel().isSelectionEmpty()) {
            return "";
        }
        return this.tree.getSelectionModel().getSelectionPath().getLastPathComponent().toString();
    }

    private void treeValueChanged(TreeSelectionEvent e) {
        this.selectionLabel.setText(this.getCurrentSelection());
        if (this.closePopupOnTreeSelection) {
            this.popupMenu.setVisible(false);
        }
    }

    public static class JTreePopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;
        private JTree tree;
        private JScrollPane scrollPane;
        private JPanel buttonsPanel;
        private boolean closeButtonVisible;
        private boolean expandAllButtonVisible;
        private boolean collapseAllButtonVisible;

        public JTreePopupMenu(JTree tree) {
            this(tree, true, true, true);
        }

        public JTreePopupMenu(JTree tree, boolean closeButtonVisible, boolean expandAllButtonVisible, boolean collapseAllButtonVisible) {
            this.tree = tree;
            this.closeButtonVisible = closeButtonVisible;
            this.expandAllButtonVisible = expandAllButtonVisible;
            this.collapseAllButtonVisible = collapseAllButtonVisible;
            this.setLayout(new BorderLayout());
            this.add(this.getTreeViewScrollPane(), "Center");
            this.add(this.getButtonsPanel(), "South");
        }

        private Component getTreeViewScrollPane() {
            if (this.scrollPane == null) {
                JPanel treePanel = new JPanel();
                treePanel.setLayout(new BorderLayout());
                treePanel.add((Component)this.tree, "North");
                treePanel.setBackground(this.tree.getBackground());
                this.scrollPane = new JScrollPane(treePanel);
                this.scrollPane.setPreferredSize(new Dimension(400, 400));
                this.scrollPane.getVerticalScrollBar().setUnitIncrement(15);
            }
            return this.scrollPane;
        }

        private Component getButtonsPanel() {
            if (this.buttonsPanel == null) {
                this.buttonsPanel = new JPanel(new FlowLayout(2));
                final JButton closeButton = new JButton("Close");
                closeButton.setVisible(this.closeButtonVisible);
                closeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (e.getSource() == closeButton) {
                            this.setVisible(false);
                        }
                    }
                });
                final JButton collapseAllButton = new JButton("Collapse all");
                collapseAllButton.setVisible(this.collapseAllButtonVisible);
                collapseAllButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (e.getSource() == collapseAllButton) {
                            JTreeUtils.collapseAll(tree);
                        }
                    }
                });
                final JButton expandAllButton = new JButton("Expand all");
                expandAllButton.setVisible(this.expandAllButtonVisible);
                expandAllButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (e.getSource() == expandAllButton) {
                            JTreeUtils.expandAll(tree);
                        }
                    }
                });
                this.buttonsPanel.add(closeButton);
                this.buttonsPanel.add(collapseAllButton);
                this.buttonsPanel.add(expandAllButton);
            }
            return this.buttonsPanel;
        }
    }
}

