/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.input;

import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RadioButtonsPanel<T>
extends JPanel
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(RadioButtonsPanel.class.getName());
    private static final int DEFAULT_PANEL_ROWS = 0;
    private static final int DEFAULT_PANEL_COLUMNS = 1;
    private Map<JRadioButton, T> buttonToItem = new HashMap<JRadioButton, T>();
    private ButtonGroup group = new ButtonGroup();
    private List<T> values;
    private int buttonsPanelRows = 0;
    private int buttonsPanelColumns = 1;

    public RadioButtonsPanel(T[] items) {
        this(Arrays.asList(items));
    }

    public RadioButtonsPanel(List<T> items) {
        this(items, 0, 1);
    }

    public RadioButtonsPanel(T[] items, int rows, int columns) {
        this(Arrays.asList(items), rows, columns);
    }

    public RadioButtonsPanel(List<T> items, int rows, int columns) {
        this.values = items;
        this.buttonsPanelRows = rows;
        this.buttonsPanelColumns = columns;
        this.initComponent();
    }

    private void initComponent() {
        this.add(this.getRadioButtonsPanel());
    }

    private JPanel getRadioButtonsPanel() {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(this.createLayout());
        for (T o : this.values) {
            JRadioButton button = new JRadioButton(o.toString());
            button.addItemListener(this);
            this.group.add(button);
            buttonsPanel.add(button);
            this.buttonToItem.put(button, o);
        }
        if (this.group.getButtonCount() > 0) {
            this.group.getElements().nextElement().setSelected(true);
        }
        return buttonsPanel;
    }

    private LayoutManager createLayout() {
        if (this.buttonsPanelColumns == 0 && this.buttonsPanelRows == 0) {
            LOGGER.warning("Warning: both rows and columns can't be 0, default values are used");
            this.buttonsPanelRows = 0;
            this.buttonsPanelColumns = 1;
        }
        return new GridLayout(this.buttonsPanelRows, this.buttonsPanelColumns);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        for (ItemListener i : this.getItemListeners()) {
            i.itemStateChanged(e);
        }
    }

    public Optional<T> getSelectedItem() {
        Object selectedItem = null;
        Enumeration<AbstractButton> buttons = this.group.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            if (!button.isSelected()) continue;
            selectedItem = this.buttonToItem.get(button);
            break;
        }
        return Optional.ofNullable(selectedItem);
    }

    public boolean setSelectedItem(T item) {
        item = Objects.requireNonNull(item);
        Enumeration<AbstractButton> buttons = this.group.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            if (!this.buttonToItem.get(button).equals(item)) continue;
            button.setSelected(true);
            return true;
        }
        return false;
    }

    public boolean isValidSelection() {
        return this.getSelectedItem().isPresent();
    }

    @Override
    public void setEnabled(boolean enabled) {
        Collections.list(this.group.getElements()).forEach(b -> b.setEnabled(enabled));
        super.setEnabled(enabled);
    }

    public void addItemListener(ItemListener l) {
        this.listenerList.add(ItemListener.class, l);
    }

    public void removeItemListener(ItemListener l) {
        this.listenerList.remove(ItemListener.class, l);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(ItemListener.class);
    }
}

