/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.sequencesgroup;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.sing_group.seda.bio.SequenceUtils;
import org.sing_group.seda.core.operations.BasePresence;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.transformation.sequencesgroup.FilterSequencesGroupTransformation;

public class FilterByBasePresenceTransformation
extends FilterSequencesGroupTransformation {
    public FilterByBasePresenceTransformation(List<BasePresence> basePresences) {
        this(DatatypeFactory.getDefaultDatatypeFactory(), basePresences);
    }

    public FilterByBasePresenceTransformation(BasePresence ... basePresences) {
        this(Arrays.asList(basePresences));
    }

    public FilterByBasePresenceTransformation(DatatypeFactory factory, BasePresence ... basePresences) {
        this(factory, Arrays.asList(basePresences));
    }

    public FilterByBasePresenceTransformation(DatatypeFactory factory, List<BasePresence> basePresences) {
        super((Sequence sequence) -> FilterByBasePresenceTransformation.filterByBasePresences(sequence, basePresences), factory);
    }

    private static boolean filterByBasePresences(Sequence s, List<BasePresence> basePresences) {
        Map<Character, Integer> baseCounts = SequenceUtils.countBases(s.getChain());
        for (BasePresence basePresence : basePresences) {
            int count = 0;
            for (Character base : basePresence.getBases()) {
                count += baseCounts.getOrDefault(base, 0).intValue();
            }
            double basePercentage = (double)count / (double)s.getLength();
            if (!(basePercentage < basePresence.getMinimumPresence()) && !(basePercentage > basePresence.getMaximumPresence())) continue;
            return false;
        }
        return true;
    }
}

