/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.provider.filtering.base;

import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.core.operations.BasePresence;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.ComposedSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.provider.filtering.base.FilterByBaseConfigurationEventType;
import org.sing_group.seda.transformation.sequencesgroup.FilterByBasePresenceTransformation;

@XmlRootElement
public class FilterByBasePresenceTransformationProvider
extends AbstractTransformationProvider {
    @XmlElement
    private List<BasePresence> basePresences = new LinkedList<BasePresence>();

    @Override
    public boolean isValidTransformation() {
        return !this.basePresences.isEmpty();
    }

    @Override
    public Validation validate() {
        if (this.basePresences.isEmpty()) {
            return new DefaultValidation("No base presence selected");
        }
        return new DefaultValidation(new String[0]);
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        return new ComposedSequencesGroupDatasetTransformation(new FilterByBasePresenceTransformation(factory, this.basePresences));
    }

    public void setBasePresences(List<BasePresence> basePresences) {
        if (basePresences != null && !this.basePresences.equals(basePresences)) {
            this.basePresences = basePresences;
            this.fireTransformationsConfigurationModelEvent(FilterByBaseConfigurationEventType.BASES_CHANGED, this.basePresences);
        }
    }

    public List<BasePresence> getBasePresences() {
        return this.basePresences;
    }
}

