/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class CountingInputStream
extends FilterInputStream {
    private long position = 0L;
    private long mark = -1L;

    public long getPosition() {
        return this.position;
    }

    public CountingInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int read = super.read();
        if (read != -1) {
            ++this.position;
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readCount = super.read(b, off, len);
        this.position += (long)readCount;
        return readCount;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int readCount = super.read(b);
        this.position += (long)readCount;
        return readCount;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = super.skip(n);
        this.position += skipped;
        return skipped;
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.mark = this.position;
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            super.reset();
            this.position = this.mark;
        }
        catch (IOException ioe) {
            this.mark = -1L;
        }
    }
}

