/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.filtering.header;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXTextField;
import org.sing_group.gc4s.event.DocumentAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.seda.core.filtering.RegexConfiguration;
import org.sing_group.seda.core.filtering.RegexHeaderMatcher;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.gui.GuiUtils;
import org.sing_group.seda.plugin.core.info.common.RegexHeaderMatcherInfo;

public class RegexHeaderMatcherConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_REGEX_GROUP = 0;
    private static final boolean DEFAULT_IS_QUOTE_PATTERN = false;
    private static final boolean DEFAULT_CASE_SENSITIVE = false;
    private static final HeaderTarget DEFAULT_HEADER_TARGET = HeaderTarget.NAME;
    private static final String PROPERTY_REGEX_CHANGED = "property.regex.string";
    private static final String PROPERTY_IS_QUOTE_PATTERN_CHANGED = "property.regex.quotepattern";
    private static final String PROPERTY_REGEX_GROUP_CHANGED = "property.regex.group";
    private static final String PROPERTY_CASE_SENSITIVE_CHANGED = "property.regex.casesensitive";
    private static final String PROPERTY_HEADER_TARGET_CHANGED = "property.regex.headertarget";
    public static final Set<String> PROPERTIES = new HashSet<String>(Arrays.asList("property.regex.string", "property.regex.quotepattern", "property.regex.group", "property.regex.casesensitive", "property.regex.headertarget"));
    private JXTextField stringTextField;
    private JCheckBox isQuotePatternCheckBox;
    private JSpinner regexGroupSpinner;
    private JComboBox<HeaderTarget> headerTargetComboBox;
    private JCheckBox caseSensitiveCheckBox;
    private String oldStringValue = "";
    private boolean oldIsQuotePatternValue = false;
    private int oldRegexGroupValue = 0;
    private HeaderTarget oldHeaderTargetValue = DEFAULT_HEADER_TARGET;
    private boolean oldCaseSensitiveValue = false;

    public RegexHeaderMatcherConfigurationPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)new InputParametersPanel(this.getInputParameters()));
    }

    private InputParameter[] getInputParameters() {
        LinkedList<InputParameter> inputParameters = new LinkedList<InputParameter>();
        inputParameters.add(this.getStringParameter());
        inputParameters.add(this.getCaseSensitiveParameter());
        inputParameters.add(this.getIsQuotePatternParameter());
        inputParameters.add(this.getRegexGroupParameter());
        inputParameters.add(this.getHeaderTargetParameter());
        return inputParameters.toArray(new InputParameter[inputParameters.size()]);
    }

    private InputParameter getStringParameter() {
        this.stringTextField = new JXTextField("String to match");
        this.stringTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void removeUpdate(DocumentEvent e) {
                RegexHeaderMatcherConfigurationPanel.this.stringChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                RegexHeaderMatcherConfigurationPanel.this.stringChanged();
            }
        });
        return new InputParameter("String to match:", (JComponent)this.stringTextField, RegexHeaderMatcherInfo.PARAM_REGEX_STRING_HELP_GUI);
    }

    private void stringChanged() {
        String newValue = this.getString();
        this.firePropertyChange(PROPERTY_REGEX_CHANGED, this.oldStringValue, newValue);
        this.oldStringValue = newValue;
        this.checkString();
    }

    private void checkString() {
        Color backgroundColor = this.isValidString() ? null : GuiUtils.COLOR_ERROR;
        String tooltip = this.isValid() ? null : "The introduced regular expression is not valid, please, revise it.";
        this.stringTextField.setBackground(backgroundColor);
        this.stringTextField.setToolTipText(tooltip);
    }

    private InputParameter getCaseSensitiveParameter() {
        this.caseSensitiveCheckBox = new JCheckBox("Case sensitive?", false);
        this.caseSensitiveCheckBox.addItemListener(this::caseSensitiveChanged);
        return new InputParameter("", (JComponent)this.caseSensitiveCheckBox, RegexHeaderMatcherInfo.PARAM_REGEX_CASE_SENSITIVE_HELP_GUI);
    }

    private void caseSensitiveChanged(ItemEvent event) {
        boolean newValue = this.isCaseSensitive();
        this.firePropertyChange(PROPERTY_CASE_SENSITIVE_CHANGED, this.oldCaseSensitiveValue, newValue);
        this.oldCaseSensitiveValue = newValue;
    }

    private InputParameter getIsQuotePatternParameter() {
        this.isQuotePatternCheckBox = new JCheckBox("Quote pattern?", false);
        this.isQuotePatternCheckBox.addItemListener(this::isQuotePatternChanged);
        return new InputParameter("", (JComponent)this.isQuotePatternCheckBox, RegexHeaderMatcherInfo.PARAM_REGEX_QUOTE_PATTERN_HELP_GUI);
    }

    private void isQuotePatternChanged(ItemEvent event) {
        boolean newValue = this.isQuotePattern();
        this.firePropertyChange(PROPERTY_IS_QUOTE_PATTERN_CHANGED, this.oldIsQuotePatternValue, newValue);
        this.oldIsQuotePatternValue = newValue;
        this.setInputControlsEnabled(this.isQuotePatternCheckBox.isEnabled());
        this.checkString();
    }

    private InputParameter getRegexGroupParameter() {
        this.regexGroupSpinner = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        this.regexGroupSpinner.addChangeListener(this::regexGroupChanged);
        return new InputParameter("Regex group:", (JComponent)this.regexGroupSpinner, RegexHeaderMatcherInfo.PARAM_REGEX_GROUP_HELP_GUI);
    }

    private void regexGroupChanged(ChangeEvent event) {
        int newValue = this.getRegexGroup();
        this.firePropertyChange(PROPERTY_REGEX_GROUP_CHANGED, this.oldRegexGroupValue, newValue);
        this.oldRegexGroupValue = newValue;
    }

    private InputParameter getHeaderTargetParameter() {
        this.headerTargetComboBox = new JComboBox<HeaderTarget>(HeaderTarget.values());
        this.headerTargetComboBox.setSelectedItem((Object)DEFAULT_HEADER_TARGET);
        this.headerTargetComboBox.addItemListener(this::headerTargetChanged);
        return new InputParameter("Header target:", this.headerTargetComboBox, RegexHeaderMatcherInfo.PARAM_REGEX_HEADER_TARGET_HELP_GUI);
    }

    private void headerTargetChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            HeaderTarget newValue = this.getHeaderTarget();
            this.firePropertyChange(PROPERTY_HEADER_TARGET_CHANGED, (Object)this.oldHeaderTargetValue, (Object)newValue);
            this.oldHeaderTargetValue = newValue;
        }
    }

    public Optional<RegexHeaderMatcher> getRegexHeaderMatcher() {
        if (this.getString().isEmpty() || !this.isValidConfiguration()) {
            return Optional.empty();
        }
        return Optional.of(this.createRegexHeaderMatcher());
    }

    public boolean isValidConfiguration() {
        return this.isValidString();
    }

    private RegexHeaderMatcher createRegexHeaderMatcher() {
        return new RegexHeaderMatcher(this.getString(), this.getHeaderTarget(), new RegexConfiguration(this.isCaseSensitive(), this.getRegexGroup(), this.isQuotePattern()));
    }

    private boolean isValidString() {
        try {
            this.createRegexHeaderMatcher();
            return true;
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    public boolean isQuotePattern() {
        return this.isQuotePatternCheckBox.isSelected();
    }

    public void setQuotePattern(boolean newQuotePattern) {
        this.isQuotePatternCheckBox.setSelected(newQuotePattern);
    }

    public int getRegexGroup() {
        return (Integer)this.regexGroupSpinner.getValue();
    }

    public void setRegexGroup(int newRegexGroup) {
        this.regexGroupSpinner.setValue(newRegexGroup);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitiveCheckBox.isSelected();
    }

    public void setCaseSensitive(boolean newCaseSensitive) {
        this.caseSensitiveCheckBox.setSelected(newCaseSensitive);
    }

    public HeaderTarget getHeaderTarget() {
        return (HeaderTarget)((Object)this.headerTargetComboBox.getSelectedItem());
    }

    public void setHeaderTarget(HeaderTarget newHeaderTarget) {
        this.headerTargetComboBox.setSelectedItem((Object)newHeaderTarget);
    }

    public String getString() {
        return this.stringTextField.getText();
    }

    public void setString(String newString) {
        this.stringTextField.setText(newString);
    }

    public void setInputControlsEnabled(boolean enabled) {
        this.stringTextField.setEnabled(enabled);
        this.isQuotePatternCheckBox.setEnabled(enabled);
        this.regexGroupSpinner.setEnabled(enabled);
        this.headerTargetComboBox.setEnabled(enabled);
        this.caseSensitiveCheckBox.setEnabled(enabled);
    }

    public void clearRegexHeaderMatcher() {
        this.stringTextField.setText("");
        this.caseSensitiveCheckBox.setSelected(false);
        this.isQuotePatternCheckBox.setSelected(false);
        this.regexGroupSpinner.setValue(0);
        this.headerTargetComboBox.setSelectedItem((Object)DEFAULT_HEADER_TARGET);
    }

    public void setRegexHeaderMatcher(RegexHeaderMatcher regexHeaderMatcher) {
        this.stringTextField.setText(regexHeaderMatcher.getString());
        this.caseSensitiveCheckBox.setSelected(regexHeaderMatcher.getRegexConfig().isCaseSensitive());
        this.isQuotePatternCheckBox.setSelected(regexHeaderMatcher.getRegexConfig().isQuotePattern());
        this.regexGroupSpinner.setValue(regexHeaderMatcher.getRegexConfig().getGroup());
        this.headerTargetComboBox.setSelectedItem((Object)regexHeaderMatcher.getHeaderTarget());
    }
}

