/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.yacli;

import es.uvigo.ei.sing.yacli.CLIApplication;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;

public abstract class CommandLine
implements Runnable {
    protected String getExitCommand() {
        return "quit";
    }

    protected abstract Class<? extends CLIApplication> getCLIApplication();

    @Override
    public void run() {
        Class<? extends CLIApplication> cli = this.getCLIApplication();
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line;
            System.setErr(System.out);
            CLIApplication application = cli.newInstance();
            application.setShowApplicationCommandInHelp(false);
            System.out.println("Welcome to " + application.getApplicationName());
            System.out.print("> ");
            while ((line = br.readLine()) != null && !line.equals(this.getExitCommand())) {
                String[] tokens = CommandLine.tokenize(line);
                application.run(tokens);
                System.out.print("\n> ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addToken(StringBuilder builder, List<String> result) {
        if (builder.length() > 0) {
            result.add(builder.toString());
            builder.setLength(0);
        }
    }

    private static String[] tokenize(String commandLine) {
        LinkedList<String> tokens = new LinkedList<String>();
        if (commandLine != null) {
            int commandLength = commandLine.length();
            boolean insideQuotes = false;
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < commandLength; ++i) {
                char c = commandLine.charAt(i);
                if (c == '\"') {
                    CommandLine.addToken(builder, tokens);
                    insideQuotes = !insideQuotes;
                    continue;
                }
                if (c == '\\') {
                    if (commandLength > i + 1 && (commandLine.charAt(i + 1) == '\"' || commandLine.charAt(i + 1) == '\\')) {
                        builder.append(commandLine.charAt(i + 1));
                        ++i;
                        continue;
                    }
                    builder.append("\\");
                    continue;
                }
                if (insideQuotes) {
                    builder.append(c);
                    continue;
                }
                if (Character.isWhitespace(c)) {
                    CommandLine.addToken(builder, tokens);
                    continue;
                }
                builder.append(c);
            }
            CommandLine.addToken(builder, tokens);
        }
        return tokens.toArray(new String[tokens.size()]);
    }
}

