/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.uniprot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class EbiFastaDownloader {
    private static final String BASE_URL = "https://www.uniprot.org/uniprot/";
    private static final int DELAY = 1000;

    public static void downloadFasta(File output, List<String> entries) throws IOException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        for (String entry : entries) {
            HttpGet httpGet = new HttpGet(BASE_URL + entry + ".fasta");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                try (FileOutputStream outstream = new FileOutputStream(output, true);){
                    response.getEntity().writeTo((OutputStream)outstream);
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new IOException("Error downloading entry " + entry);
        }
    }

    public static void main(String[] args) throws IOException {
        EbiFastaDownloader.downloadFasta(new File("/tmp/test.fasta"), Arrays.asList("F7CN20", "B0X778", "A0A0P0WRT9"));
    }
}

