/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.transformation.provider.ncbi;

import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.blast.ncbi.NcbiBlastDatabase;
import org.sing_group.seda.blast.ncbi.NcbiBlastType;
import org.sing_group.seda.blast.ncbi.parameters.ExpectValueParameter;
import org.sing_group.seda.blast.ncbi.parameters.FilterParameter;
import org.sing_group.seda.blast.ncbi.parameters.HitListSizeParameter;
import org.sing_group.seda.blast.ncbi.parameters.MatrixParameter;
import org.sing_group.seda.blast.ncbi.parameters.NcbiBlastParameter;
import org.sing_group.seda.blast.ncbi.parameters.OutputTypeParameter;
import org.sing_group.seda.blast.ncbi.parameters.ThresholdParameter;
import org.sing_group.seda.blast.ncbi.parameters.WordSizeParameter;
import org.sing_group.seda.blast.transformation.dataset.NcbiBlastTransformation;
import org.sing_group.seda.blast.transformation.provider.ncbi.NcbiBlastTransformationConfigurationChangeType;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

@XmlRootElement
public class NcbiBlastTransformationProvider
extends AbstractTransformationProvider {
    @XmlElement
    private NcbiBlastType blastType;
    @XmlElement
    private NcbiBlastDatabase blastDatabase;
    @XmlElement
    private OutputTypeParameter outputType;
    @XmlElement
    private MatrixParameter matrix;
    @XmlElement
    private FilterParameter filter;
    @XmlElement
    private Double expectValue;
    @XmlElement
    private Integer hitListSize;
    @XmlElement
    private Integer wordSize;
    @XmlElement
    private Integer threshold;

    public NcbiBlastTransformationProvider() {
    }

    public NcbiBlastTransformationProvider(NcbiBlastType blastType, NcbiBlastDatabase blastDatabase, OutputTypeParameter outputType) {
        this.blastType = blastType;
        this.blastDatabase = blastDatabase;
        this.outputType = outputType;
    }

    @Override
    public Validation validate() {
        LinkedList<String> validationErrors = new LinkedList<String>();
        if (this.blastType == null) {
            validationErrors.add("The BLAST type can't be null");
        }
        if (this.blastDatabase == null) {
            validationErrors.add("The BLAST database can't be null");
        }
        if (this.outputType == null) {
            validationErrors.add("The output type can't be null");
        }
        if (!this.blastType.getDatabaseType().equals((Object)this.blastDatabase.getSequenceType())) {
            validationErrors.add("The BLAST type and database are not compatible");
        }
        if (this.expectValue != null && this.expectValue < 0.0) {
            validationErrors.add("The expectation value can't be lower than 0");
        }
        if (this.hitListSize != null && this.hitListSize < 0) {
            validationErrors.add("The hits list size can't be lower than 0");
        }
        if (this.wordSize != null && this.wordSize < 0) {
            validationErrors.add("The word size can't be lower than 0");
        }
        if (this.threshold != null && this.threshold < 0) {
            validationErrors.add("The thrshold can't be lower than 0");
        }
        if (validationErrors.isEmpty()) {
            return new DefaultValidation(new String[0]);
        }
        return new DefaultValidation(validationErrors);
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        if (!this.isValidTransformation()) {
            throw new IllegalStateException("The current transformation configuration is not valid");
        }
        return new NcbiBlastTransformation(this.blastType, this.blastDatabase, this.outputType, this.getBlastParameters(), factory);
    }

    private List<NcbiBlastParameter> getBlastParameters() {
        LinkedList<NcbiBlastParameter> parameters = new LinkedList<NcbiBlastParameter>();
        if (this.expectValue != null && this.expectValue > 0.0) {
            parameters.add(new ExpectValueParameter(this.expectValue));
        }
        if (this.hitListSize != null && this.hitListSize > 0) {
            parameters.add(new HitListSizeParameter(this.hitListSize));
        }
        if (this.wordSize != null && this.wordSize > 0) {
            parameters.add(new WordSizeParameter(this.wordSize));
        }
        if (this.threshold != null && this.threshold > 0) {
            parameters.add(new ThresholdParameter(this.threshold));
        }
        if (this.matrix != null) {
            parameters.add(this.matrix);
        }
        if (this.filter != null) {
            parameters.add(this.filter);
        }
        return parameters;
    }

    public void setBlastType(NcbiBlastType blastType) {
        if (this.blastType == null || !this.blastType.equals((Object)blastType)) {
            this.blastType = blastType;
            this.fireTransformationsConfigurationModelEvent(NcbiBlastTransformationConfigurationChangeType.BLAST_TYPE_CHANGED, (Object)this.blastType);
        }
    }

    public NcbiBlastType getBlastType() {
        return this.blastType;
    }

    public void setBlastDatabase(NcbiBlastDatabase blastDatabase) {
        if (this.blastDatabase == null || !this.blastDatabase.equals((Object)blastDatabase)) {
            this.blastDatabase = blastDatabase;
            this.fireTransformationsConfigurationModelEvent(NcbiBlastTransformationConfigurationChangeType.BLAST_DATABASE_CHANGED, (Object)this.blastDatabase);
        }
    }

    public NcbiBlastDatabase getBlastDatabase() {
        return this.blastDatabase;
    }

    public void setOutputType(OutputTypeParameter outputType) {
        if (this.outputType == null || !this.outputType.equals((Object)outputType)) {
            this.outputType = outputType;
            this.fireTransformationsConfigurationModelEvent(NcbiBlastTransformationConfigurationChangeType.OUTPUT_TYPE_CHANGED, (Object)this.outputType);
        }
    }

    public OutputTypeParameter getOutputType() {
        return this.outputType;
    }

    public void setMatrix(MatrixParameter matrix) {
        if (this.matrix == null || !this.matrix.equals(matrix)) {
            this.matrix = matrix;
            this.fireTransformationsConfigurationModelEvent(NcbiBlastTransformationConfigurationChangeType.MATRIX_CHANGED, this.matrix);
        }
    }

    public MatrixParameter getMatrix() {
        return this.matrix;
    }

    public void setFilter(FilterParameter filter) {
        if (this.filter == null || !this.filter.equals(filter)) {
            this.filter = filter;
            this.fireTransformationsConfigurationModelEvent(NcbiBlastTransformationConfigurationChangeType.FILTER_CHANGED, this.filter);
        }
    }

    public FilterParameter getFilter() {
        return this.filter;
    }

    public void setExpectValue(double expectValue) {
        if (this.expectValue == null || !this.expectValue.equals(expectValue)) {
            this.expectValue = expectValue;
            this.fireTransformationsConfigurationModelEvent(NcbiBlastTransformationConfigurationChangeType.EXPECT_VALUE_CHANGED, this.expectValue);
        }
    }

    public void clearExpectValue() {
        if (this.expectValue != null) {
            this.expectValue = null;
            this.fireTransformationsConfigurationModelEvent(NcbiBlastTransformationConfigurationChangeType.EXPECT_VALUE_CHANGED, this.expectValue);
        }
    }

    public void setHitListSizeValue(int hitListSize) {
        if (this.hitListSize == null || !this.hitListSize.equals(hitListSize)) {
            this.hitListSize = hitListSize;
            this.fireTransformationsConfigurationModelEvent(NcbiBlastTransformationConfigurationChangeType.HIT_LIST_SIZE_VALUE_CHANGED, this.hitListSize);
        }
    }

    public Double getExpectValue() {
        return this.expectValue;
    }

    public void clearHitListSize() {
        if (this.hitListSize != null) {
            this.hitListSize = null;
            this.fireTransformationsConfigurationModelEvent(NcbiBlastTransformationConfigurationChangeType.HIT_LIST_SIZE_VALUE_CHANGED, this.hitListSize);
        }
    }

    public Integer getHitListSize() {
        return this.hitListSize;
    }

    public void setWordSizeValue(int wordSize) {
        if (this.wordSize == null || !this.wordSize.equals(wordSize)) {
            this.wordSize = wordSize;
            this.fireTransformationsConfigurationModelEvent(NcbiBlastTransformationConfigurationChangeType.WORD_SIZE_VALUE_CHANGED, this.wordSize);
        }
    }

    public void clearWordSize() {
        if (this.wordSize != null) {
            this.wordSize = null;
            this.fireTransformationsConfigurationModelEvent(NcbiBlastTransformationConfigurationChangeType.WORD_SIZE_VALUE_CHANGED, this.wordSize);
        }
    }

    public Integer getWordSize() {
        return this.wordSize;
    }

    public void setThresholdValue(int threshold) {
        if (this.threshold == null || !this.threshold.equals(threshold)) {
            this.threshold = threshold;
            this.fireTransformationsConfigurationModelEvent(NcbiBlastTransformationConfigurationChangeType.THRESHOLD_CHANGED, this.threshold);
        }
    }

    public void clearThresholdValue() {
        if (this.threshold != null) {
            this.threshold = null;
            this.fireTransformationsConfigurationModelEvent(NcbiBlastTransformationConfigurationChangeType.THRESHOLD_CHANGED, this.threshold);
        }
    }

    public Integer getThreshold() {
        return this.threshold;
    }
}

