/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.transformation.dataset;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.sing_group.seda.blast.datatype.DatabaseQueryMode;
import org.sing_group.seda.blast.datatype.blast.BlastType;
import org.sing_group.seda.blast.execution.BlastBinariesExecutor;
import org.sing_group.seda.blast.transformation.dataset.BlastTransformation;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.transformation.TransformationException;

public class BlastTransformationBuilder {
    private BlastType blastType;
    private DatabaseQueryMode databaseQueryMode;
    private File queryFile;
    private double eValue = 0.05;
    private int maxTargetSeqs = 500000;
    private File databasesDirectory = null;
    private BlastBinariesExecutor blastBinariesExecutor;
    private File aliasFile;
    private String blastAdditionalParameters = "";
    private DatatypeFactory factory = DatatypeFactory.getDefaultDatatypeFactory();
    private boolean extractOnlyHitRegions = false;
    private int hitRegionsWindowSize = 0;

    public BlastTransformationBuilder(BlastType blastType, File queryFile, DatabaseQueryMode databaseQueryMode) {
        this.blastType = blastType;
        this.queryFile = queryFile;
        this.databaseQueryMode = databaseQueryMode;
    }

    public BlastTransformationBuilder withEvalue(double eValue) {
        this.eValue = eValue;
        return this;
    }

    public BlastTransformationBuilder withMaxTargetSeqs(int maxTargetSeqs) {
        this.maxTargetSeqs = maxTargetSeqs;
        return this;
    }

    public BlastTransformationBuilder withDatabasesDirectory(File databasesDirectory) {
        this.databasesDirectory = databasesDirectory;
        return this;
    }

    public BlastTransformationBuilder withAliasFile(File aliasFile) {
        this.aliasFile = aliasFile;
        return this;
    }

    public BlastTransformationBuilder withBlastBinariesExecutor(BlastBinariesExecutor blastBinariesExecutor) {
        this.blastBinariesExecutor = blastBinariesExecutor;
        return this;
    }

    public BlastTransformationBuilder withBlastAditionalParameters(String blastAdditionalParameters) {
        this.blastAdditionalParameters = blastAdditionalParameters;
        return this;
    }

    public BlastTransformationBuilder withExtractOnlyHitRegions(boolean extractOnlyHitRegions) {
        this.extractOnlyHitRegions = extractOnlyHitRegions;
        return this;
    }

    public BlastTransformationBuilder withHitRegionsWindowSize(int hitRegionsWindowSize) {
        this.hitRegionsWindowSize = hitRegionsWindowSize;
        return this;
    }

    public BlastTransformationBuilder withDatatypeFactory(DatatypeFactory factory) {
        this.factory = factory;
        return this;
    }

    public BlastTransformation build() {
        try {
            if (this.getAliasFile().isPresent()) {
                return new BlastTransformation(this.blastType, this.databaseQueryMode, this.blastBinariesExecutor, this.queryFile, this.getDatabasesDirectory(), this.getAliasFile().get(), this.eValue, this.maxTargetSeqs, this.extractOnlyHitRegions, this.hitRegionsWindowSize, this.blastAdditionalParameters, this.factory);
            }
            return new BlastTransformation(this.blastType, this.databaseQueryMode, this.blastBinariesExecutor, this.queryFile, this.getDatabasesDirectory(), this.eValue, this.maxTargetSeqs, this.extractOnlyHitRegions, this.hitRegionsWindowSize, this.blastAdditionalParameters, this.factory);
        }
        catch (IOException e) {
            throw new TransformationException(e);
        }
    }

    private File getDatabasesDirectory() throws IOException {
        return this.databasesDirectory == null ? Files.createTempDirectory("seda-blastdb", new FileAttribute[0]).toFile() : this.databasesDirectory;
    }

    private Optional<File> getAliasFile() throws IOException {
        return Optional.ofNullable(this.aliasFile);
    }
}

