/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.ncbi;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.sing_group.seda.blast.ncbi.NcbiBlastDatabase;
import org.sing_group.seda.blast.ncbi.NcbiBlastHits;
import org.sing_group.seda.blast.ncbi.NcbiBlastRequestPageParser;
import org.sing_group.seda.blast.ncbi.NcbiBlastRequestStatus;
import org.sing_group.seda.blast.ncbi.NcbiBlastType;
import org.sing_group.seda.blast.ncbi.parameters.NcbiBlastParameter;
import org.xml.sax.SAXException;

public class NcbiBlastRequest {
    private static final String BASE_URL = "https://blast.ncbi.nlm.nih.gov/blast/Blast.cgi";
    private NcbiBlastType blastType;
    private NcbiBlastDatabase blastDatabase;
    private String query;
    private List<NcbiBlastParameter> parameters;
    private String requestId;
    private NcbiBlastRequestStatus status;
    private NcbiBlastHits blastHits;

    public NcbiBlastRequest(String requestId) {
        this.requestId = requestId;
    }

    public NcbiBlastRequest(NcbiBlastType blastType, NcbiBlastDatabase blastDatabase, String query, List<NcbiBlastParameter> parameters) {
        this.blastType = blastType;
        this.blastDatabase = blastDatabase;
        this.query = query;
        this.parameters = parameters;
        this.checkBlastAndDatabaseCompatibility();
    }

    private void checkBlastAndDatabaseCompatibility() {
        if (!this.blastType.getDatabaseType().equals((Object)this.blastDatabase.getSequenceType())) {
            throw new IllegalArgumentException("The selected BLAST operation requires a " + this.blastType.getDatabaseType().toString() + " database but the selected database type is " + (Object)((Object)this.blastDatabase.getSequenceType()));
        }
    }

    public void query() throws ClientProtocolException, IOException, URISyntaxException {
        if (this.requestId != null) {
            throw new RuntimeException("A query has already been done with request ID = " + this.requestId);
        }
        URIBuilder ub = new URIBuilder(BASE_URL);
        ub.addParameter("CMD", "Put");
        ub.addParameter("PROGRAM", this.blastType.getProgram());
        ub.addParameter("DATABASE", this.blastDatabase.getName());
        ub.addParameter("QUERY", this.query);
        this.parameters.forEach(p -> ub.addParameter(p.paramName(), p.value()));
        HttpPost httpPost = new HttpPost(ub.toString());
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
        httpClient.close();
        this.requestId = NcbiBlastRequestPageParser.getRequestId(responseString);
    }

    public Optional<String> getRequestId() {
        return Optional.ofNullable(this.requestId);
    }

    public NcbiBlastRequestStatus getStatus() throws URISyntaxException, ClientProtocolException, IOException {
        if (this.requestId == null) {
            return NcbiBlastRequestStatus.UNSUBMITED;
        }
        if (this.status == null || this.status == NcbiBlastRequestStatus.WAITING) {
            URIBuilder ub = new URIBuilder(BASE_URL);
            ub.addParameter("CMD", "Get");
            ub.addParameter("FORMAT_OBJECT", "SearchInfo");
            ub.addParameter("RID", this.requestId);
            HttpGet httpGet = new HttpGet(ub.toString());
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            httpClient.close();
            this.status = NcbiBlastRequestPageParser.getRequestStatus(responseString);
        }
        return this.status;
    }

    public NcbiBlastHits getBlastHits() throws URISyntaxException, ClientProtocolException, IOException {
        if (this.requestId == null) {
            throw new RuntimeException("The query has not been submited yet");
        }
        if (this.blastHits == null) {
            if (this.getStatus().equals((Object)NcbiBlastRequestStatus.READY_WITH_HITS)) {
                URIBuilder ub = new URIBuilder(BASE_URL);
                ub.addParameter("CMD", "Get");
                ub.addParameter("FORMAT_TYPE", "XML");
                ub.addParameter("RID", this.requestId);
                HttpGet httpGet = new HttpGet(ub.toString());
                CloseableHttpClient httpClient = HttpClientBuilder.create().build();
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
                httpClient.close();
                try {
                    this.blastHits = NcbiBlastHits.fromXml(responseString);
                }
                catch (SAXException e) {
                    throw new IOException(e);
                }
            } else {
                this.blastHits = new NcbiBlastHits();
            }
        }
        return this.blastHits;
    }
}

