/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.cli.twowayblast;

import es.uvigo.ei.sing.yacli.command.option.BigDecimalDefaultValuedStringConstructedOption;
import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.FileOption;
import es.uvigo.ei.sing.yacli.command.option.IntegerDefaultValuedStringConstructedOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sing_group.seda.blast.cli.blast.BlastCommand;
import org.sing_group.seda.blast.datatype.TwoWayBlastMode;
import org.sing_group.seda.blast.datatype.blast.BlastType;
import org.sing_group.seda.blast.execution.AbstractBlastBinariesExecutor;
import org.sing_group.seda.blast.execution.BlastBinariesExecutor;
import org.sing_group.seda.blast.execution.DefaultBlastBinariesExecutor;
import org.sing_group.seda.blast.execution.DockerBlastBinariesExecutor;
import org.sing_group.seda.blast.plugin.core.BlastSedaPluginInfo;
import org.sing_group.seda.blast.plugin.core.TwoWayBlastSedaPluginInfo;
import org.sing_group.seda.blast.transformation.provider.twowayblast.TwoWayBlastTransformationProvider;
import org.sing_group.seda.cli.ExternalSoftwareExecutionCommand;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.plugin.spi.TransformationProvider;

public class TwoWayBlastCommand
extends ExternalSoftwareExecutionCommand {
    public static final StringOption OPTION_DOCKER_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "docker-mode", "dk", "The BLAST docker image. By default, the official SEDA image for BLAST is used. If you provide a custom image, it should have the BLAST commands available in the path.", true, true);
    public static final StringOption OPTION_LOCAL_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "local-mode", "lc", "The directory that contains the BLAST binaries. Leave it empty if they are in the path.", true, true);
    public static final FileOption OPTION_STORE_DATABASES_DIRECTORY = new FileOption("store-databases-directory", "sdd", "The directory where databases must be stored.", true, true);
    public static final DefaultValuedStringOption OPTION_QUERY_MODE = new DefaultValuedStringOption("query-mode", "qm", TwoWayBlastSedaPluginInfo.PARAM_QUERY_MODE_HELP, TwoWayBlastSedaPluginInfo.DEFAULT_QUERY_MODE.name());
    public static final DefaultValuedStringOption OPTION_QUERY_BLAST_TYPE = new DefaultValuedStringOption("query-blast-type", "qbt", BlastSedaPluginInfo.PARAM_QUERY_BLAST_TYPE_HELP, BlastSedaPluginInfo.DEFAULT_BLAST_TYPE.name().toLowerCase());
    public static final FileOption OPTION_QUERY_FILE = new FileOption("query-file", "qf", "The file that contains the sequences that must be used for the BLAST queries.", true, true);
    public static final BigDecimalDefaultValuedStringConstructedOption OPTION_EXPECTATION_VALUE = new BigDecimalDefaultValuedStringConstructedOption("evalue", "ev", "The expectation value (E) threshold for saving hits.", BigDecimal.valueOf(0.05));
    public static final StringOption OPTION_ADDITIONAL_PARAMS = new StringOption("additional-params", "ad", "Additional parameters for the BLAST command.", true, true);
    public static final IntegerDefaultValuedStringConstructedOption OPTION_NUM_THREADS = new IntegerDefaultValuedStringConstructedOption("num-threads", "th", "Number of threads to use.", Integer.valueOf(1));

    public String getName() {
        return "blast-ortholog";
    }

    public String getDescriptiveName() {
        return "BLAST: two-way ortholog identification";
    }

    public String getDescription() {
        return "Find sequence orthologs in a set of FASTA files using the Reciprocal Best Hits method.";
    }

    @Override
    protected String getSedaGroup() {
        return TwoWayBlastSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> getMandatoryOptions() {
        return Arrays.asList(OPTION_QUERY_FILE);
    }

    @Override
    protected Map<Option<?>, String> getLocalOptionsToEnablePropertyMap() {
        return TwoWayBlastCommand.fromKeyValue(OPTION_LOCAL_MODE, "seda.local.execution.enabled.blast");
    }

    @Override
    protected List<Option<?>> getLocalOptionsList() {
        return Arrays.asList(OPTION_LOCAL_MODE);
    }

    @Override
    protected List<Option<?>> createExternalSedaOptions() {
        return Arrays.asList(OPTION_LOCAL_MODE, OPTION_DOCKER_MODE, OPTION_STORE_DATABASES_DIRECTORY, OPTION_QUERY_MODE, OPTION_QUERY_BLAST_TYPE, OPTION_QUERY_FILE, OPTION_EXPECTATION_VALUE, OPTION_ADDITIONAL_PARAMS, OPTION_NUM_THREADS);
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        TwoWayBlastTransformationProvider provider = new TwoWayBlastTransformationProvider();
        provider.setBlastType(this.getBlastType(parameters));
        provider.setEvalue(this.getEvalue(parameters));
        provider.setQueryFile(this.getExistingFile(parameters, OPTION_QUERY_FILE));
        provider.setQueryMode(this.getQueryMode(parameters));
        Optional<File> databasesDirectory = BlastCommand.getDatabasesDirectory(parameters, OPTION_STORE_DATABASES_DIRECTORY);
        if (databasesDirectory.isPresent()) {
            provider.setStoreDatabases(true);
            provider.setDatabasesDirectory(databasesDirectory.get());
        }
        Optional<String> additionalParameters = this.getAdditionalParameters(parameters);
        additionalParameters.ifPresent(provider::setAdditionalParameters);
        provider.setNumThreads(this.getNumThreads(parameters));
        provider.setBlastBinariesExecutor(this.getBlastBinariesExecutor(parameters));
        return provider;
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, TwoWayBlastTransformationProvider.class);
    }

    private BlastType getBlastType(Parameters parameters) {
        try {
            return BlastType.valueOf(parameters.getSingleValueString((Option)OPTION_QUERY_BLAST_TYPE).toUpperCase());
        }
        catch (IllegalArgumentException exc) {
            TwoWayBlastCommand.invalidEnumValue(OPTION_QUERY_BLAST_TYPE);
            throw new IllegalStateException();
        }
    }

    private double getEvalue(Parameters parameters) {
        try {
            return ((BigDecimal)parameters.getSingleValue((Option)OPTION_EXPECTATION_VALUE)).doubleValue();
        }
        catch (NumberFormatException ex) {
            TwoWayBlastCommand.formattedValidationError("Invalid value for " + TwoWayBlastCommand.formatParam(OPTION_EXPECTATION_VALUE) + " (" + parameters.getSingleValue((Option)OPTION_EXPECTATION_VALUE) + "). It must be a number.");
            throw new IllegalStateException();
        }
    }

    private TwoWayBlastMode getQueryMode(Parameters parameters) {
        try {
            return TwoWayBlastMode.valueOf(parameters.getSingleValueString((Option)OPTION_QUERY_MODE).toUpperCase());
        }
        catch (IllegalArgumentException exc) {
            TwoWayBlastCommand.invalidEnumValue(OPTION_QUERY_MODE);
            throw new IllegalStateException();
        }
    }

    private Optional<String> getAdditionalParameters(Parameters parameters) {
        if (!parameters.hasOption((Option)OPTION_ADDITIONAL_PARAMS)) {
            return Optional.empty();
        }
        return Optional.of(parameters.getSingleValue((Option)OPTION_ADDITIONAL_PARAMS));
    }

    private int getNumThreads(Parameters parameters) {
        try {
            return (Integer)parameters.getSingleValue((Option)OPTION_NUM_THREADS);
        }
        catch (NumberFormatException ex) {
            TwoWayBlastCommand.formattedValidationError("Invalid value for " + TwoWayBlastCommand.formatParam(OPTION_NUM_THREADS) + " (" + parameters.getSingleValue((Option)OPTION_NUM_THREADS) + "). It must be a number.");
            throw new IllegalStateException();
        }
    }

    private Optional<BlastBinariesExecutor> getBlastBinariesExecutor(Parameters parameters) {
        AbstractBlastBinariesExecutor executor = new DockerBlastBinariesExecutor(DockerBlastBinariesExecutor.getDefaultDockerImage());
        if (parameters.hasOption((Option)OPTION_LOCAL_MODE)) {
            File blastBinariesDirectory = new File(parameters.getSingleValueString((Option)OPTION_LOCAL_MODE));
            if (blastBinariesDirectory.isDirectory()) {
                executor = new DefaultBlastBinariesExecutor(blastBinariesDirectory);
            } else {
                TwoWayBlastCommand.formattedValidationError("The specified BLAST directory it is not a directory or does not exist.");
            }
        }
        if (parameters.hasOption((Option)OPTION_DOCKER_MODE)) {
            executor = new DockerBlastBinariesExecutor((String)parameters.getSingleValue((Option)OPTION_DOCKER_MODE));
        }
        return Optional.of(executor);
    }
}

