/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.cli.ncbi;

import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.IntegerOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.sing_group.seda.blast.ncbi.NcbiBlastDatabase;
import org.sing_group.seda.blast.ncbi.NcbiBlastType;
import org.sing_group.seda.blast.ncbi.parameters.FilterParameter;
import org.sing_group.seda.blast.ncbi.parameters.MatrixParameter;
import org.sing_group.seda.blast.ncbi.parameters.OutputTypeParameter;
import org.sing_group.seda.blast.plugin.core.NcbiBlastSedaPluginInfo;
import org.sing_group.seda.blast.transformation.provider.ncbi.NcbiBlastTransformationProvider;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.plugin.spi.TransformationProvider;

public class NcbiBlastCommand
extends SedaCommand {
    public static final StringOption OPTION_BLAST_TYPE = new StringOption("blast-type", "bt", NcbiBlastSedaPluginInfo.PARAM_NCBI_BLAST_TYPE_HELP, true, true);
    public static final StringOption OPTION_BLAST_DATABASE = new StringOption("blast-database", "blast-database", NcbiBlastSedaPluginInfo.PARAM_NCBI_BLAST_DATABASE_HELP, true, true);
    public static final DefaultValuedStringOption OPTION_OUTPUT_TYPE = new DefaultValuedStringOption("output-type", "ot", NcbiBlastSedaPluginInfo.PARAM_OUTPUT_TYPE_HELP, NcbiBlastSedaPluginInfo.DEFAULT_OUTPUT_TYPE.name().toLowerCase());
    public static final StringOption OPTION_MATRIX = new StringOption("matrix", "m", NcbiBlastSedaPluginInfo.PARAM_MATRIX_HELP, true, true);
    public static final FlagOption OPTION_FILTER = new FlagOption("filter", "f", "Low complexity filtering.");
    public static final FlagOption OPTION_FILTER_LOOKUP = new FlagOption("filter-lookup", "fl", "Mask at lookup.");
    public static final StringOption OPTION_EVALUE = new StringOption("evalue", "ev", "The expectation value (E) threshold for saving hits.", true, true);
    public static final IntegerOption OPTION_WORD_SIZE = new IntegerOption("word-size", "ws", "Size of word for initial matches.", true);
    public static final IntegerOption OPTION_HITS_LIST_SIZE = new IntegerOption("hits-list-size", "hls", "Number of databases sequences to keep.", true);
    public static final IntegerOption OPTION_THRESHOLD = new IntegerOption("threshold", "th", "Neighboring score for initial words. Does not apply to BLASTN or MegaBLAST.", true);

    public String getName() {
        return "blast-ncbi";
    }

    public String getDescriptiveName() {
        return "NCBI BLAST";
    }

    public String getDescription() {
        return "Perform a BLAST query through the NCBI web server (https://blast.ncbi.nlm.nih.gov/Blast.cgi).";
    }

    @Override
    protected String getSedaGroup() {
        return NcbiBlastSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> getMandatoryOptions() {
        return Arrays.asList(OPTION_BLAST_TYPE, OPTION_BLAST_DATABASE);
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        return Arrays.asList(OPTION_BLAST_TYPE, OPTION_BLAST_DATABASE, OPTION_OUTPUT_TYPE, OPTION_MATRIX, OPTION_FILTER, OPTION_FILTER_LOOKUP, OPTION_EVALUE, OPTION_WORD_SIZE, OPTION_HITS_LIST_SIZE, OPTION_THRESHOLD);
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        NcbiBlastTransformationProvider provider = new NcbiBlastTransformationProvider();
        provider.setBlastDatabase(NcbiBlastCommand.getEnumValue(parameters, NcbiBlastDatabase.class, OPTION_BLAST_DATABASE));
        provider.setBlastType(NcbiBlastCommand.getEnumValue(parameters, NcbiBlastType.class, OPTION_BLAST_TYPE));
        provider.setOutputType(NcbiBlastCommand.getEnumValue(parameters, OutputTypeParameter.class, OPTION_OUTPUT_TYPE));
        if (parameters.hasOption((Option)OPTION_MATRIX)) {
            provider.setMatrix(NcbiBlastCommand.getEnumValue(parameters, MatrixParameter.class, OPTION_MATRIX));
        }
        provider.setFilter(this.getFilter(parameters));
        if (parameters.hasOption((Option)OPTION_EVALUE)) {
            provider.setExpectValue(NcbiBlastCommand.getDoubleValue(parameters, (Option<String>)OPTION_EVALUE));
        }
        if (parameters.hasOption((Option)OPTION_HITS_LIST_SIZE)) {
            provider.setHitListSizeValue((Integer)parameters.getSingleValue((Option)OPTION_HITS_LIST_SIZE));
        }
        if (parameters.hasOption((Option)OPTION_WORD_SIZE)) {
            provider.setWordSizeValue((Integer)parameters.getSingleValue((Option)OPTION_WORD_SIZE));
        }
        if (parameters.hasOption((Option)OPTION_THRESHOLD)) {
            provider.setThresholdValue((Integer)parameters.getSingleValue((Option)OPTION_THRESHOLD));
        }
        return provider;
    }

    private FilterParameter getFilter(Parameters parameters) {
        if (parameters.hasFlag((Option)OPTION_FILTER)) {
            return new FilterParameter(true, parameters.hasFlag((Option)OPTION_FILTER_LOOKUP));
        }
        return new FilterParameter(false);
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, NcbiBlastTransformationProvider.class);
    }
}

