/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cga.execution;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.sing_group.seda.cga.execution.CgaBinariesExecutor;
import org.sing_group.seda.cga.execution.CgaPipelineParameters;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.io.FastaWriter;

public class CgaPipeline {
    private static final String INPUT_FASTA = "input.fasta";
    private static final String REFERENCE_FASTA = "ref.fasta";
    private static final String PARAMS = "cga.params";
    private static final String README = "README.txt";
    private CgaBinariesExecutor cgaBinaries;
    private CgaPipelineParameters parameters;
    private SequencesGroup input;
    private SequencesGroup reference;

    public CgaPipeline(CgaBinariesExecutor cgaBinaries, CgaPipelineParameters parameters, SequencesGroup input, SequencesGroup reference) throws IOException {
        this.cgaBinaries = cgaBinaries;
        this.parameters = parameters;
        this.input = input;
        this.reference = reference;
    }

    public void run() throws IOException, InterruptedException {
        this.initWorkingDir();
        this.cgaBinaries.run(this.parameters.getWorkingDir(), this.parameters.getAdditionalCompiParameters());
    }

    private void initWorkingDir() throws IOException, InterruptedException {
        File workingDir = this.parameters.getWorkingDir();
        this.cgaBinaries.initWorkingDir(workingDir, INPUT_FASTA, REFERENCE_FASTA, PARAMS, README);
        FastaWriter.writeFasta(new File(workingDir, INPUT_FASTA).toPath(), this.input.getSequences());
        FastaWriter.writeFasta(new File(workingDir, REFERENCE_FASTA).toPath(), this.reference.getSequences());
        this.parameters.store(new FileOutputStream(new File(workingDir, PARAMS)), "Generated by SEDA");
    }
}

