/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.sequencesgroup;

import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.sing_group.seda.core.filtering.HeaderMatcher;
import org.sing_group.seda.core.filtering.HeaderMatcherCount;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupBuilder;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.sequencesgroup.SequencesGroupTransformation;

public class HeaderCountFilteringSequencesGroupTransformation
implements SequencesGroupTransformation {
    private final SequencesGroupBuilder builder = factory::newSequencesGroup;
    private HeaderMatcher matcher;
    private int min;
    private int max;
    private boolean include;

    public HeaderCountFilteringSequencesGroupTransformation(HeaderMatcher matcher, int min, int max, boolean include) {
        this(DatatypeFactory.getDefaultDatatypeFactory(), matcher, min, max, include);
    }

    public HeaderCountFilteringSequencesGroupTransformation(DatatypeFactory factory, HeaderMatcher matcher, int min, int max, boolean include) {
        this.matcher = matcher;
        this.min = min;
        this.max = max;
        this.include = include;
    }

    @Override
    public SequencesGroup transform(SequencesGroup sequencesGroup) throws TransformationException {
        LinkedList<Sequence> newSequences = new LinkedList<Sequence>();
        Map<String, Integer> counts = new HeaderMatcherCount(this.matcher).count(sequencesGroup);
        sequencesGroup.getSequences().forEach(s -> {
            Optional<String> match = this.matcher.match((Sequence)s);
            if (match.isPresent()) {
                int count = (Integer)counts.get(match.get());
                if (count >= this.min && count <= this.max) {
                    if (this.include) {
                        newSequences.add((Sequence)s);
                    }
                } else if (!this.include) {
                    newSequences.add((Sequence)s);
                }
            }
        });
        return this.builder.of(sequencesGroup.getName(), sequencesGroup.getProperties(), newSequences);
    }
}

