/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.dataset;

import java.util.function.Function;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupDataset;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

public class SequenceCountFilterSequencesGroupDatasetTransformation
implements SequencesGroupDatasetTransformation {
    private final Function<SequencesGroup[], SequencesGroupDataset> builder = factory::newSequencesGroupDataset;
    private final int minSequences;
    private final int maxSequences;

    public SequenceCountFilterSequencesGroupDatasetTransformation(int minSequences, int maxSequences) {
        this(minSequences, maxSequences, DatatypeFactory.getDefaultDatatypeFactory());
    }

    public SequenceCountFilterSequencesGroupDatasetTransformation(int minSequences, int maxSequences, DatatypeFactory factory) {
        this.minSequences = minSequences;
        this.maxSequences = maxSequences;
    }

    @Override
    public SequencesGroupDataset transform(SequencesGroupDataset dataset) {
        SequencesGroup[] sequencesGroups = (SequencesGroup[])dataset.getSequencesGroups().filter(sequenceGroup -> {
            if (this.minSequences > 0 && sequenceGroup.getSequenceCount() < this.minSequences) {
                return false;
            }
            return this.maxSequences <= 0 || sequenceGroup.getSequenceCount() <= this.maxSequences;
        }).toArray(SequencesGroup[]::new);
        if (sequencesGroups.length == 0) {
            throw new TransformationException("No sequences after filtering");
        }
        return this.builder.apply(sequencesGroups);
    }
}

