/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.execution;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.jdesktop.swingx.JXTextField;
import org.sing_group.gc4s.ui.icons.Icons;
import org.sing_group.gc4s.utilities.ExtendedAbstractAction;
import org.sing_group.gc4s.utilities.builder.JButtonBuilder;
import org.sing_group.seda.gui.execution.BinaryConfigurationPanelListener;
import org.sing_group.seda.gui.execution.BinaryExecutionConfigurationPanel;

public abstract class AbstractDockerExecutionConfigurationPanel<T>
extends JPanel
implements BinaryExecutionConfigurationPanel<T> {
    private static final long serialVersionUID = 1L;
    protected final JTextField dockerImage = new JXTextField("Docker image");
    private JButton checkDockerButton;

    public AbstractDockerExecutionConfigurationPanel(String defaultDockerImage) {
        this(defaultDockerImage, "");
    }

    public AbstractDockerExecutionConfigurationPanel(String defaultDockerImage, String helpTooltip) {
        this.dockerImage.setText(defaultDockerImage);
        this.dockerImage.setColumns(20);
        this.checkDockerButton = JButtonBuilder.newJButtonBuilder().thatDoes(this.getCheckDockerAction()).build();
        JLabel helpLabel = new JLabel(Icons.ICON_INFO_2_16);
        helpLabel.setToolTipText(helpTooltip);
        JPanel dockerImagePanel = new JPanel(new FlowLayout());
        dockerImagePanel.add(this.dockerImage);
        if (!helpTooltip.trim().isEmpty()) {
            dockerImagePanel.add(helpLabel);
        }
        dockerImagePanel.add(this.checkDockerButton);
        this.setLayout(new BorderLayout());
        this.add((Component)dockerImagePanel, "North");
    }

    private Action getCheckDockerAction() {
        return new ExtendedAbstractAction("Check image", this::checkDockerButton);
    }

    private void checkDockerButton() {
        this.dockerImageChanged(new ChangeEvent(this));
    }

    private void dockerImageChanged(ChangeEvent event) {
        this.checkDockerButton.setEnabled(!this.dockerImage.getText().isEmpty());
        SwingUtilities.invokeLater(() -> {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.checkBinary();
            this.fireBinariesExecutorChanged();
            this.setCursor(Cursor.getDefaultCursor());
        });
    }

    private void fireBinariesExecutorChanged() {
        for (BinaryConfigurationPanelListener<T> listener : this.getBinaryConfigurationPanelListeners()) {
            listener.onBinariesExecutorChanged(this);
        }
    }

    protected abstract void checkBinary();

    protected Component getParentForDialogs() {
        return SwingUtilities.getRootPane(this);
    }

    public String getSelectedDockerImage() {
        return this.dockerImage.getText();
    }

    @Override
    public synchronized void addBinaryConfigurationPanelListener(BinaryConfigurationPanelListener<T> l) {
        this.listenerList.add(BinaryConfigurationPanelListener.class, l);
    }

    @Override
    public synchronized BinaryConfigurationPanelListener<T>[] getBinaryConfigurationPanelListeners() {
        BinaryConfigurationPanelListener[] listeners = (BinaryConfigurationPanelListener[])this.listenerList.getListeners(BinaryConfigurationPanelListener.class);
        return listeners;
    }

    public void setSelectedDockerImage(String dockerImage) {
        this.dockerImage.setText(dockerImage);
    }
}

