/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.pattern;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import org.sing_group.seda.datatype.pattern.EvaluableSequencePattern;
import org.sing_group.seda.datatype.pattern.SequencePatternGroup;
import org.sing_group.seda.gui.configuration_panel.pattern.PatternEditionEvent;
import org.sing_group.seda.gui.configuration_panel.pattern.SequencePatternEditorListener;
import org.sing_group.seda.gui.configuration_panel.pattern.SequencePatternGroupPanel;

public class MultipleSequencePatternGroupPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox<EvaluableSequencePattern.GroupMode> patternsModeCombo;
    private JPanel groupsPanel;
    private List<SequencePatternGroupPanelComponent> groupsComponents = new ArrayList<SequencePatternGroupPanelComponent>();

    public MultipleSequencePatternGroupPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add(this.getNorthComponent(), "North");
        this.add(this.getCenterComponent(), "Center");
    }

    private Component getNorthComponent() {
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BoxLayout(northPanel, 0));
        northPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        northPanel.add(new JLabel("Required groups: "));
        northPanel.add(this.getPatternsModeCombobox());
        northPanel.add(Box.createHorizontalGlue());
        northPanel.add(Box.createHorizontalStrut(5));
        northPanel.add(this.getAddPatternButton());
        return northPanel;
    }

    private Component getPatternsModeCombobox() {
        this.patternsModeCombo = new JComboBox<EvaluableSequencePattern.GroupMode>(EvaluableSequencePattern.GroupMode.values());
        this.patternsModeCombo.addItemListener(this::modeComboChanged);
        return this.patternsModeCombo;
    }

    private void modeComboChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.notifyPatternEdited(new PatternEditionEvent(this, PatternEditionEvent.PatternEditionType.MODE));
        }
    }

    private JButton getAddPatternButton() {
        JButton addPattern = new JButton("Add pattern group");
        addPattern.addActionListener(event -> this.addSequencePatternGroupPanel());
        return addPattern;
    }

    private Component getCenterComponent() {
        JPanel centerPanel = new JPanel();
        this.groupsPanel = new JPanel();
        this.groupsPanel.setLayout(new BoxLayout(this.groupsPanel, 1));
        centerPanel.add(this.groupsPanel);
        this.addSequencePatternGroupPanel();
        return new JScrollPane(centerPanel);
    }

    private void addSequencePatternGroupPanel() {
        this.addSequencePatternGroupPanel(new SequencePatternGroupPanelComponent());
    }

    private void addSequencePatternGroupPanel(SequencePatternGroupPanelComponent newComponent) {
        newComponent.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1), "Patterns group"));
        newComponent.addSequencePatternEditorListener(new SequencePatternEditorListener(){

            @Override
            public void patternRemoved(ChangeEvent event) {
                MultipleSequencePatternGroupPanel.this.notifyPatternRemoved(event);
            }

            @Override
            public void patternEdited(PatternEditionEvent event) {
                MultipleSequencePatternGroupPanel.this.notifyPatternEdited(event);
            }

            @Override
            public void patternAdded(ChangeEvent event) {
                MultipleSequencePatternGroupPanel.this.notifyPatternAdded(event);
            }
        });
        this.groupsComponents.add(newComponent);
        this.groupsPanel.add(newComponent);
        this.notifyPatternAdded();
    }

    private void removeSequencePatternGroupPanel(SequencePatternGroupPanelComponent component) {
        this.groupsComponents.remove(component);
        this.groupsPanel.remove(component);
        this.notifyPatternRemoved();
    }

    private void notifyPatternAdded() {
        this.notifyPatternAdded(new ChangeEvent(this));
    }

    private void notifyPatternAdded(ChangeEvent event) {
        for (SequencePatternEditorListener l : this.getSequencePatternEditorListeners()) {
            l.patternAdded(event);
        }
        this.updateUI();
    }

    private void notifyPatternRemoved() {
        this.notifyPatternRemoved(new ChangeEvent(this));
    }

    private void notifyPatternRemoved(ChangeEvent event) {
        for (SequencePatternEditorListener l : this.getSequencePatternEditorListeners()) {
            l.patternRemoved(event);
        }
        this.updateUI();
    }

    private void notifyPatternEdited(PatternEditionEvent event) {
        for (SequencePatternEditorListener l : this.getSequencePatternEditorListeners()) {
            l.patternEdited(event);
        }
    }

    public boolean isValidUserSelection() {
        return this.groupsComponents.size() > 0 && this.allPatternsGroupsAreValid();
    }

    private boolean allPatternsGroupsAreValid() {
        return !this.groupsComponents.stream().map(SequencePatternGroupPanel::isValidUserSelection).filter(valid -> valid == false).findAny().isPresent();
    }

    public SequencePatternGroup getSequencePatternGroup() {
        return new SequencePatternGroup(this.getSelectedMode(), this.getPatterns());
    }

    private EvaluableSequencePattern.GroupMode getSelectedMode() {
        return (EvaluableSequencePattern.GroupMode)((Object)this.patternsModeCombo.getSelectedItem());
    }

    private SequencePatternGroup[] getPatterns() {
        return this.groupsComponents.stream().map(SequencePatternGroupPanel::getSequencePatternGroup).collect(Collectors.toList()).toArray(new SequencePatternGroup[this.groupsComponents.size()]);
    }

    public synchronized void addSequencePatternEditorListener(SequencePatternEditorListener l) {
        this.listenerList.add(SequencePatternEditorListener.class, l);
    }

    public synchronized SequencePatternEditorListener[] getSequencePatternEditorListeners() {
        return (SequencePatternEditorListener[])this.listenerList.getListeners(SequencePatternEditorListener.class);
    }

    public void setSequencePatternGrup(SequencePatternGroup pattern) {
        this.patternsModeCombo.setSelectedItem((Object)pattern.getMode());
        this.groupsComponents.forEach(this.groupsPanel::remove);
        this.groupsComponents.clear();
        for (EvaluableSequencePattern esp : pattern.getPatterns()) {
            if (!(esp instanceof SequencePatternGroup)) continue;
            SequencePatternGroup group = (SequencePatternGroup)esp;
            this.addSequencePatternGroupPanel(new SequencePatternGroupPanelComponent(group));
        }
    }

    private class SequencePatternGroupPanelComponent
    extends SequencePatternGroupPanel {
        private static final long serialVersionUID = 1L;

        public SequencePatternGroupPanelComponent() {
        }

        public SequencePatternGroupPanelComponent(SequencePatternGroup group) {
            super(group);
        }

        @Override
        protected JPanel getNorthComponent() {
            JPanel northComponent = super.getNorthComponent();
            northComponent.add(Box.createHorizontalStrut(5));
            northComponent.add(this.getRemoveGroupButton());
            return northComponent;
        }

        private Component getRemoveGroupButton() {
            JButton removeGroupButton = new JButton("Remove group");
            removeGroupButton.addActionListener(event -> MultipleSequencePatternGroupPanel.this.removeSequencePatternGroupPanel(this));
            return removeGroupButton;
        }
    }
}

