/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.isoforms;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import org.sing_group.gc4s.event.DocumentAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanelBuilder;
import org.sing_group.gc4s.input.filechooser.SelectionMode;
import org.sing_group.gc4s.input.text.JIntegerTextField;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.core.filtering.RegexHeaderMatcher;
import org.sing_group.seda.core.operations.DefaultSequenceIsoformSelector;
import org.sing_group.seda.core.rename.EmptySequenceHeadersJoiner;
import org.sing_group.seda.gui.CommonFileChooser;
import org.sing_group.seda.gui.configuration_panel.filtering.header.RegexHeaderMatcherConfigurationPanel;
import org.sing_group.seda.gui.configuration_panel.isoforms.DefaultSequenceIsoformConfigurationPanel;
import org.sing_group.seda.gui.configuration_panel.isoforms.RemovedIsoformHeadersConfigurationPanel;
import org.sing_group.seda.plugin.core.info.plugin.RemoveIsoformsSedaPluginInfo;
import org.sing_group.seda.transformation.provider.isoforms.RemoveIsoformsTransformationProvider;

public class RemoveIsoformsConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String DESCRIPTION_MINIMUM_WORD_LENGTH = RemoveIsoformsSedaPluginInfo.PARAM_MINIMUM_WORD_LENGTH_HELP_GUI;
    private static final String DESCRIPTION_ISOFORM_FILES_DIRECTORY = RemoveIsoformsSedaPluginInfo.PARAM_ISOFORM_FILE_HELP_GUI;
    private static final String DESCRIPTION_ISOFORM_SELECTION_CRITERIA = "The configuration of the criteria to select which isoform should go to the output file.";
    private static final String DESCRIPTION_HEADER_MATCHER = RemoveIsoformsSedaPluginInfo.PARAM_GROUP_SEQUENCES_REGEX_HELP_GUI;
    private static final String DESCRIPTION_ADD_REMOVED_ISOFORMS = "This group of options allows to specify how removed isoforms should be processed.";
    private JIntegerTextField minimumWordLenthTf;
    private JFileChooserPanel removedIsoformsFilesDirectory;
    private DefaultSequenceIsoformConfigurationPanel isoformSelectorPanel;
    private RegexHeaderMatcherConfigurationPanel headerMatcherPanel;
    private RemovedIsoformHeadersConfigurationPanel addRemovedIsoformHeadersPanel;
    private RemoveIsoformsTransformationProvider transformationProvider = new RemoveIsoformsTransformationProvider();

    public RemoveIsoformsConfigurationPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.getParametersPanel(), "Center");
        return new CenteredJPanel(mainPanel);
    }

    private JPanel getParametersPanel() {
        return new InputParametersPanel(this.getInputParameters());
    }

    private InputParameter[] getInputParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getMinimumWordLengthParameter());
        parameters.add(this.getIsoformSelectorParameter());
        parameters.add(this.getHeaderMatcherParameter());
        parameters.add(this.getAddRemovedIsoformHeadersParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getMinimumWordLengthParameter() {
        this.minimumWordLenthTf = new JIntegerTextField((Integer)250);
        this.minimumWordLenthTf.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                RemoveIsoformsConfigurationPanel.this.minimumWordChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                RemoveIsoformsConfigurationPanel.this.minimumWordChanged();
            }
        });
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 0));
        container.add(new JLabel("Minimum word length: "));
        container.add(this.minimumWordLenthTf);
        return new InputParameter("", container, DESCRIPTION_MINIMUM_WORD_LENGTH);
    }

    private void minimumWordChanged() {
        this.transformationProvider.setMinimumWordLength(this.minimumWordLenthTf.getValue());
    }

    private InputParameter getRemovedIsoformFilesDirectoryParameter() {
        this.removedIsoformsFilesDirectory = JFileChooserPanelBuilder.createSaveJFileChooserPanel().withFileChooserSelectionMode(SelectionMode.DIRECTORIES).withFileChooser(CommonFileChooser.getInstance().getFilechooser()).withLabel("").build();
        this.removedIsoformsFilesDirectory.addFileChooserListener(this::addRemovedIsoformNamesChanged);
        return new InputParameter("Isoform files directory: ", this.removedIsoformsFilesDirectory, DESCRIPTION_ISOFORM_FILES_DIRECTORY);
    }

    private void addRemovedIsoformNamesChanged(ChangeEvent event) {
        File selectedFile = this.removedIsoformsFilesDirectory.getSelectedFile();
        if (selectedFile != null) {
            this.transformationProvider.setRemovedIsoformFilesDirectory(selectedFile);
        } else {
            this.transformationProvider.clearRemovedIsoformFilesDirectory();
        }
    }

    private InputParameter getIsoformSelectorParameter() {
        this.isoformSelectorPanel = new DefaultSequenceIsoformConfigurationPanel();
        this.isoformSelectorPanel.setBorder(BorderFactory.createTitledBorder("Isoform selection criteria"));
        this.transformationProvider.setIsoformSelector(this.isoformSelectorPanel.getSelector());
        this.isoformSelectorPanel.addPropertyChangeListener(this::isoformSelectorChanged);
        return new InputParameter("", this.isoformSelectorPanel, DESCRIPTION_ISOFORM_SELECTION_CRITERIA);
    }

    private void isoformSelectorChanged(PropertyChangeEvent event) {
        if (DefaultSequenceIsoformConfigurationPanel.PROPERTIES.contains(event.getPropertyName())) {
            this.transformationProvider.setIsoformSelector(this.isoformSelectorPanel.getSelector());
        }
    }

    private InputParameter getHeaderMatcherParameter() {
        this.headerMatcherPanel = new RegexHeaderMatcherConfigurationPanel();
        this.headerMatcherPanel.setBorder(BorderFactory.createTitledBorder("Header matcher configuration"));
        this.headerMatcherPanel.addPropertyChangeListener(this::headerMatcherChanged);
        return new InputParameter("", this.headerMatcherPanel, DESCRIPTION_HEADER_MATCHER);
    }

    private void headerMatcherChanged(PropertyChangeEvent event) {
        if (RegexHeaderMatcherConfigurationPanel.PROPERTIES.contains(event.getPropertyName())) {
            Optional<RegexHeaderMatcher> headerMatcher = this.headerMatcherPanel.getRegexHeaderMatcher();
            if (headerMatcher.isPresent()) {
                this.transformationProvider.setHeaderMatcher(headerMatcher.get());
            } else {
                this.transformationProvider.removeHeaderMatcher();
            }
        }
    }

    private InputParameter getAddRemovedIsoformHeadersParameter() {
        this.addRemovedIsoformHeadersPanel = new RemovedIsoformHeadersConfigurationPanel(this.getRemovedIsoformFilesDirectoryParameter());
        this.addRemovedIsoformHeadersPanel.setBorder(BorderFactory.createTitledBorder("Removed isoforms"));
        this.addRemovedIsoformHeadersPanel.addPropertyChangeListener(this::addRemovedIsoformHeadersChanged);
        return new InputParameter("", this.addRemovedIsoformHeadersPanel, DESCRIPTION_ADD_REMOVED_ISOFORMS);
    }

    private void addRemovedIsoformHeadersChanged(PropertyChangeEvent event) {
        if (RemovedIsoformHeadersConfigurationPanel.PROPERTIES.contains(event.getPropertyName())) {
            this.transformationProvider.setSequenceHeaderJoiner(this.addRemovedIsoformHeadersPanel.getSequenceHeadersJoiner());
        }
    }

    public RemoveIsoformsTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(RemoveIsoformsTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        this.minimumWordLenthTf.setValue(transformationProvider.getMinimumWordLengh());
        if (!(transformationProvider.getSelector() instanceof DefaultSequenceIsoformSelector)) {
            throw new IllegalArgumentException("Trying to set a SequenceIsoformSelector different DefaultSequenceIsoformSelector");
        }
        this.isoformSelectorPanel.setSelector((DefaultSequenceIsoformSelector)transformationProvider.getSelector());
        if (transformationProvider.getRegexHeaderMatcher() != null) {
            this.headerMatcherPanel.setRegexHeaderMatcher(transformationProvider.getRegexHeaderMatcher());
        } else {
            this.headerMatcherPanel.clearRegexHeaderMatcher();
        }
        if (transformationProvider.getRemovedIsoformsFilesDirectory() != null) {
            this.removedIsoformsFilesDirectory.setSelectedFile(transformationProvider.getRemovedIsoformsFilesDirectory());
        } else {
            this.removedIsoformsFilesDirectory.clearSelectedFile();
        }
        if (transformationProvider.getSequenceHeadersJoiner() != null) {
            this.addRemovedIsoformHeadersPanel.setSequenceHeadersJoiner(transformationProvider.getSequenceHeadersJoiner());
        } else {
            this.addRemovedIsoformHeadersPanel.setSequenceHeadersJoiner(new EmptySequenceHeadersJoiner());
        }
    }
}

