/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.RadioButtonsPanel;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.comparator.SequenceComparator;
import org.sing_group.seda.datatype.SequenceTarget;
import org.sing_group.seda.plugin.core.info.plugin.SortSedaPluginInfo;
import org.sing_group.seda.transformation.provider.sort.SortTransformationProvider;

public class SortTransformationConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private SortTransformationProvider transformationProvider;
    private RadioButtonsPanel<SequenceTarget> sequenceTargetRbtnPanel;
    private RadioButtonsPanel<SequenceComparator> sortCriteriaRbtnPanel;
    private JCheckBox descendingSort;

    public SortTransformationConfigurationPanel() {
        this.init();
        this.initTransformationProvider();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        return new CenteredJPanel(new InputParametersPanel(this.getParameters()));
    }

    private InputParameter[] getParameters() {
        InputParameter[] parameters = new InputParameter[]{this.getSequenceTargetParameter(), this.getSortModeParameter(), this.getSortCriteriaParameter()};
        return parameters;
    }

    private InputParameter getSequenceTargetParameter() {
        this.sequenceTargetRbtnPanel = new RadioButtonsPanel<SequenceTarget>(SequenceTarget.values(), 1, SequenceTarget.values().length);
        this.sequenceTargetRbtnPanel.setSelectedItem(SequenceTarget.SEQUENCE);
        this.sequenceTargetRbtnPanel.addItemListener(this::sequenceTargetItemListener);
        return new InputParameter("Sort on:", this.sequenceTargetRbtnPanel, SortSedaPluginInfo.PARAM_SORT_ON_HELP_GUI);
    }

    private void sequenceTargetItemListener(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.sequenceTargetChanged();
        }
    }

    private void sequenceTargetChanged() {
        this.transformationProvider.setSequenceTarget(this.sequenceTargetRbtnPanel.getSelectedItem().get());
    }

    private InputParameter getSortModeParameter() {
        this.descendingSort = new JCheckBox("Descending", false);
        this.descendingSort.addItemListener(e -> this.descendingSortChanged());
        return new InputParameter("", this.descendingSort, SortSedaPluginInfo.PARAM_DESCENDING_HELP_GUI);
    }

    private void descendingSortChanged() {
        this.transformationProvider.setDescendingSort(this.descendingSort.isSelected());
    }

    private InputParameter getSortCriteriaParameter() {
        this.sortCriteriaRbtnPanel = new RadioButtonsPanel<SequenceComparator>(SequenceComparator.values(), 1, SequenceComparator.values().length);
        this.sortCriteriaRbtnPanel.addItemListener(this::sortCriteriaItemListener);
        return new InputParameter("Criteria:", this.sortCriteriaRbtnPanel, SortSedaPluginInfo.PARAM_CRITERIA_HELP_GUI);
    }

    private void sortCriteriaItemListener(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.sortCriteriaChanged();
        }
    }

    private void sortCriteriaChanged() {
        this.transformationProvider.setSequenceComparator(this.sortCriteriaRbtnPanel.getSelectedItem().get());
    }

    public SortTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    private void initTransformationProvider() {
        this.transformationProvider = new SortTransformationProvider();
        this.sequenceTargetChanged();
        this.sortCriteriaChanged();
        this.descendingSortChanged();
    }

    public void setTransformationProvider(SortTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        if (transformationProvider.getSequenceComparator() != null) {
            this.sortCriteriaRbtnPanel.setSelectedItem(this.transformationProvider.getSequenceComparator());
        }
        if (transformationProvider.getSequenceTarget() != null) {
            this.sequenceTargetRbtnPanel.setSelectedItem(this.transformationProvider.getSequenceTarget());
        }
        this.descendingSort.setSelected(this.transformationProvider.isDescendingSort());
    }
}

