/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.sing_group.gc4s.event.DocumentAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.RadioButtonsPanel;
import org.sing_group.gc4s.input.text.ExtendedJXTextField;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.core.filtering.HeaderFilteringConfiguration;
import org.sing_group.seda.core.filtering.HeaderMatcher;
import org.sing_group.seda.core.filtering.RegexHeaderMatcher;
import org.sing_group.seda.core.filtering.SequenceNameHeaderMatcher;
import org.sing_group.seda.gui.GuiUtils;
import org.sing_group.seda.gui.configuration_panel.ReformatFastaConfigurationPanel;
import org.sing_group.seda.gui.configuration_panel.filtering.header.RegexHeaderMatcherConfigurationPanel;
import org.sing_group.seda.plugin.core.info.common.HeaderMatcherInfo;
import org.sing_group.seda.plugin.core.info.plugin.ConcatenateSequencesSedaPluginInfo;
import org.sing_group.seda.transformation.provider.concatenate.ConcatenateSequencesTransformationProvider;

public class ConcatenateSequencesConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String HELP_REGEX_MATCHER = "The regular expression configuration to match the sequence headers that must be concatenated. Check the manual for examples of regular expressions.";
    private static final Optional<HeaderMatcher> SEQUENCE_NAME_MATCHER = Optional.of(new SequenceNameHeaderMatcher());
    private ConcatenateSequencesTransformationProvider transformationProvider;
    private ReformatFastaConfigurationPanel reformatPanel;
    private ExtendedJXTextField nameTextField;
    private JCheckBox mergeDescriptions;
    private RadioButtonsPanel<HeaderFilteringConfiguration.FilterType> filterTypeRbtn;
    private RegexHeaderMatcherConfigurationPanel regexHeaderMatcherConfigurationPanel;

    public ConcatenateSequencesConfigurationPanel() {
        this.init();
        this.initTransformationProvider();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.getParametersPanel());
        mainPanel.add(this.getReformatFastaConfigurationPanel());
        return new CenteredJPanel(mainPanel);
    }

    private Component getParametersPanel() {
        return new InputParametersPanel(this.getParameters());
    }

    private InputParameter[] getParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getMergeNameParameter());
        parameters.add(this.getMergeDescriptionsParameter());
        parameters.add(this.getFilterTypeParameter());
        parameters.add(this.getHeaderMatcherConfigurationParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getMergeNameParameter() {
        this.nameTextField = new ExtendedJXTextField("name");
        this.nameTextField.setColumns(20);
        this.nameTextField.setEmptyTextFieldColor(GuiUtils.COLOR_ERROR);
        this.nameTextField.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ConcatenateSequencesConfigurationPanel.this.nameChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ConcatenateSequencesConfigurationPanel.this.nameChanged();
            }
        });
        return new InputParameter("name:", this.nameTextField, ConcatenateSequencesSedaPluginInfo.PARAM_NAME_HELP_GUI);
    }

    private void nameChanged() {
        this.transformationProvider.setMergeName(this.nameTextField.getText());
    }

    private InputParameter getMergeDescriptionsParameter() {
        this.mergeDescriptions = new JCheckBox();
        this.mergeDescriptions.addItemListener(this::mergeDescriptionsChanged);
        return new InputParameter("Merge descriptions:", this.mergeDescriptions, ConcatenateSequencesSedaPluginInfo.PARAM_MERGE_HELP_GUI);
    }

    private void mergeDescriptionsChanged(ItemEvent event) {
        this.transformationProvider.setMergeDescriptions(this.mergeDescriptions.isSelected());
    }

    private InputParameter getFilterTypeParameter() {
        this.filterTypeRbtn = new RadioButtonsPanel<HeaderFilteringConfiguration.FilterType>(HeaderFilteringConfiguration.FilterType.values(), 1, 0);
        this.filterTypeRbtn.addItemListener(this::filterTypeChanged);
        return new InputParameter("Sequence matching mode: ", this.filterTypeRbtn, HeaderMatcherInfo.PARAM_SEQUENCE_MATCHING_HELP_GUI);
    }

    private void filterTypeChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.checkStringComponent();
            this.regularExpressionChanged();
        }
    }

    private InputParameter getHeaderMatcherConfigurationParameter() {
        this.regexHeaderMatcherConfigurationPanel = new RegexHeaderMatcherConfigurationPanel();
        this.regexHeaderMatcherConfigurationPanel.setBorder(BorderFactory.createTitledBorder("Header matcher configuration"));
        this.checkStringComponent();
        this.regexHeaderMatcherConfigurationPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (RegexHeaderMatcherConfigurationPanel.PROPERTIES.contains(evt.getPropertyName())) {
                    ConcatenateSequencesConfigurationPanel.this.regularExpressionChanged();
                }
            }
        });
        return new InputParameter("", this.regexHeaderMatcherConfigurationPanel, HELP_REGEX_MATCHER);
    }

    protected void regularExpressionChanged() {
        Optional<HeaderMatcher> headerMatcher = this.getHeaderMatcher();
        if (headerMatcher.isPresent()) {
            this.transformationProvider.setHeaderMatcher(headerMatcher.get());
        } else {
            this.transformationProvider.removeHeaderMatcher();
        }
    }

    private void checkStringComponent() {
        SwingUtilities.invokeLater(() -> {
            boolean enabled = this.getFilterType().equals((Object)HeaderFilteringConfiguration.FilterType.REGEX);
            this.regexHeaderMatcherConfigurationPanel.setInputControlsEnabled(enabled);
        });
    }

    private Optional<HeaderMatcher> getHeaderMatcher() {
        if (this.filterTypeRbtn.getSelectedItem().get().equals((Object)HeaderFilteringConfiguration.FilterType.SEQUENCE_NAME)) {
            return SEQUENCE_NAME_MATCHER;
        }
        return Optional.ofNullable(this.regexHeaderMatcherConfigurationPanel.getRegexHeaderMatcher().orElse(null));
    }

    private HeaderFilteringConfiguration.FilterType getFilterType() {
        return this.filterTypeRbtn.getSelectedItem().get();
    }

    private Component getReformatFastaConfigurationPanel() {
        this.reformatPanel = new ReformatFastaConfigurationPanel();
        this.reformatPanel.setBorder(BorderFactory.createTitledBorder("Reformat output file"));
        return this.reformatPanel;
    }

    private void initTransformationProvider() {
        this.transformationProvider = new ConcatenateSequencesTransformationProvider();
        this.transformationProvider.setReformatFastaTransformationProvider(this.reformatPanel.getTransformationProvider());
        this.transformationProvider.setHeaderMatcher(SEQUENCE_NAME_MATCHER.get());
    }

    public ConcatenateSequencesTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(ConcatenateSequencesTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        this.nameTextField.setText(this.transformationProvider.getMergeName());
        this.mergeDescriptions.setSelected(this.transformationProvider.isMergeDescriptions());
        if (this.transformationProvider.getHeaderMatcher() instanceof SequenceNameHeaderMatcher) {
            this.filterTypeRbtn.setSelectedItem(HeaderFilteringConfiguration.FilterType.SEQUENCE_NAME);
        } else {
            this.regexHeaderMatcherConfigurationPanel.setRegexHeaderMatcher((RegexHeaderMatcher)this.transformationProvider.getHeaderMatcher());
            this.filterTypeRbtn.setSelectedItem(HeaderFilteringConfiguration.FilterType.REGEX);
        }
        this.reformatPanel.setTransformationProvider(this.transformationProvider.getReformatFastaTransformationProvider());
    }
}

