/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.RadioButtonsPanel;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.datatype.SequenceTarget;
import org.sing_group.seda.gui.configuration_panel.ReformatFastaConfigurationPanel;
import org.sing_group.seda.plugin.core.info.plugin.CompareSequencesSedaPluginInfo;
import org.sing_group.seda.transformation.provider.compare.CompareSequencesGroupDatasetTransformationProvider;

public class CompareSequencesGroupDatasetConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String SEQUENCE_TARGET_HELP = CompareSequencesSedaPluginInfo.PARAM_SEQUENCE_TARGET_HELP_GUI;
    private RadioButtonsPanel<SequenceTarget> sequenceTargetSelection;
    private CompareSequencesGroupDatasetTransformationProvider transformationProvider;
    private ReformatFastaConfigurationPanel reformatPanel;

    public CompareSequencesGroupDatasetConfigurationPanel() {
        this.init();
        this.initTransformationProvider();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.getParametersPanel());
        mainPanel.add(this.getReformatFastaConfigurationPanel());
        return new CenteredJPanel(mainPanel);
    }

    private JPanel getParametersPanel() {
        return new InputParametersPanel(this.getInputParameters());
    }

    private InputParameter getInputParameters() {
        this.sequenceTargetSelection = new RadioButtonsPanel<SequenceTarget>(SequenceTarget.values(), 1, 2);
        this.sequenceTargetSelection.setSelectedItem(CompareSequencesGroupDatasetTransformationProvider.DEFAULT_SEQUENCE_TARGET);
        this.sequenceTargetSelection.addItemListener(this::sequenceTargetChanged);
        return new InputParameter("Sequence target:", this.sequenceTargetSelection, SEQUENCE_TARGET_HELP);
    }

    private Component getReformatFastaConfigurationPanel() {
        this.reformatPanel = new ReformatFastaConfigurationPanel();
        this.reformatPanel.setBorder(BorderFactory.createTitledBorder("Reformat output file"));
        return this.reformatPanel;
    }

    private void sequenceTargetChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.transformationProvider.setSequenceTarget(this.sequenceTargetSelection.getSelectedItem().get());
        }
    }

    private void initTransformationProvider() {
        this.transformationProvider = new CompareSequencesGroupDatasetTransformationProvider();
        this.transformationProvider.setReformatFastaTransformationProvider(this.reformatPanel.getTransformationProvider());
    }

    public CompareSequencesGroupDatasetTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(CompareSequencesGroupDatasetTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        this.sequenceTargetSelection.setSelectedItem(this.transformationProvider.getSequenceTarget());
        this.reformatPanel.setTransformationProvider(this.transformationProvider.getReformatFastaTransformationProvider());
    }
}

