/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.DefaultFormatter;
import org.sing_group.gc4s.event.DocumentAdapter;
import org.sing_group.gc4s.input.RadioButtonsPanel;
import org.sing_group.gc4s.input.text.JIntegerTextField;

public final class GuiUtils {
    public static final Color COLOR_ERROR = Color.decode("#FF9494");

    private GuiUtils() {
    }

    public static <T> void bindRadioButtonsPanel(RadioButtonsPanel<T> chk, Consumer<T> setter) {
        chk.addItemListener(event -> {
            if (chk.getSelectedItem().isPresent()) {
                setter.accept(chk.getSelectedItem().get());
            }
        });
    }

    public static void bindCheckBox(JCheckBox chk, Consumer<Boolean> setter) {
        chk.addItemListener(event -> setter.accept(chk.isSelected()));
    }

    public static void bindToggleButton(JToggleButton toggleButton, Consumer<Boolean> setter) {
        toggleButton.addItemListener(event -> setter.accept(toggleButton.isSelected()));
    }

    public static void bindIntegerTextField(final JIntegerTextField textField, final IntConsumer setter) {
        textField.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateValue();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateValue();
            }

            private void updateValue() {
                setter.accept(textField.getValue());
            }
        });
    }

    public static void bindSpinner(JSpinner spn, IntConsumer setter) {
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)spn.getEditor();
        JFormattedTextField txtField = editor.getTextField();
        DefaultFormatter formatter = (DefaultFormatter)txtField.getFormatter();
        formatter.setCommitsOnValidEdit(true);
        spn.addChangeListener(event -> setter.accept((Integer)spn.getValue()));
    }

    public static void showFileChooserAndProcess(JFileChooser fileChooser, Component parent, int selectionMode, int dialogMode, boolean multipleSelection, List<FileFilter> fileFilters, Consumer<Path> pathProcessor) {
        GuiUtils.showFileChooserAndProcess(fileChooser, parent, selectionMode, dialogMode, multipleSelection, fileFilters, pathProcessor, () -> {});
    }

    public static void showFileChooserAndProcess(JFileChooser fileChooser, Component parent, int selectionMode, int dialogMode, boolean multipleSelection, List<FileFilter> fileFilters, Consumer<Path> pathProcessor, Runnable onCancel) {
        int option;
        fileChooser.setFileSelectionMode(selectionMode);
        fileChooser.setMultiSelectionEnabled(multipleSelection);
        fileChooser.setSelectedFile(new File(""));
        if (!fileFilters.isEmpty()) {
            fileFilters.forEach(fileChooser::addChoosableFileFilter);
        }
        if ((option = GuiUtils.showFileChooser(fileChooser, dialogMode, parent)) == 0) {
            if (multipleSelection) {
                Arrays.stream(fileChooser.getSelectedFiles()).map(File::toPath).forEach(pathProcessor);
            } else {
                pathProcessor.accept(fileChooser.getSelectedFile().toPath());
            }
        } else {
            onCancel.run();
        }
        if (!fileFilters.isEmpty()) {
            fileFilters.forEach(fileChooser::removeChoosableFileFilter);
        }
    }

    private static int showFileChooser(JFileChooser fileChooser, int dialogMode, Component parent) {
        if (dialogMode == 1) {
            return fileChooser.showSaveDialog(parent);
        }
        return fileChooser.showOpenDialog(parent);
    }

    public static void configureUI() {
        UIManager.put("ToolTip.font", ((Font)UIManager.get("ToolTip.font")).deriveFont(14.0f));
    }

    public static boolean openWebpage(URI uri) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uri);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

