/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.ncbi;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class NcbiDatasetProcessor {
    private File zipFile;

    public NcbiDatasetProcessor(File zipFile) throws FileNotFoundException {
        if (zipFile == null || !zipFile.exists() || !zipFile.canRead()) {
            throw new FileNotFoundException("The provided file does not exist or is not readable.");
        }
        this.zipFile = zipFile;
    }

    public List<File> process(File outputDirectory) throws IOException {
        File[] subDirs;
        ArrayList<File> extractedFiles = new ArrayList<File>();
        File tempDir = Files.createTempDirectory("ncbi_dataset", new FileAttribute[0]).toFile();
        try (ZipFile zip = new ZipFile(this.zipFile);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryDestination = new File(tempDir, entry.getName());
                if (entry.isDirectory()) {
                    entryDestination.mkdirs();
                    continue;
                }
                entryDestination.getParentFile().mkdirs();
                InputStream in = zip.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileOutputStream out = new FileOutputStream(entryDestination);
                    Throwable throwable2 = null;
                    try {
                        int length;
                        byte[] buffer = new byte[1024];
                        while ((length = in.read(buffer)) > 0) {
                            out.write(buffer, 0, length);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        File dataDir = new File(tempDir, "ncbi_dataset/data");
        if (dataDir.exists() && dataDir.isDirectory() && (subDirs = dataDir.listFiles(File::isDirectory)) != null) {
            for (File subDir : subDirs) {
                File[] files = subDir.listFiles();
                if (files == null) continue;
                for (File file : files) {
                    File renamedFile = new File(outputDirectory, subDir.getName() + ".fasta");
                    if (!renamedFile.exists()) {
                        Files.move(file.toPath(), renamedFile.toPath(), new CopyOption[0]);
                    } else {
                        System.out.println("File " + renamedFile.getAbsolutePath() + " already exists. Skipping.");
                    }
                    extractedFiles.add(renamedFile);
                }
            }
        }
        return extractedFiles;
    }

    public static void main(String[] args) {
        args = new String[]{"/home/hlfernandez/Investigacion/Work_In_Progress/SEDA_Fix_NCBI_Rename/ncbi_dataset.zip", "/tmp/test"};
        if (args.length < 2) {
            System.out.println("Usage: java NcbiDatasetProcessor <path_to_zip_file> <output_directory>");
            return;
        }
        try {
            File inputFile = new File(args[0]);
            File outputDirectory = new File(args[1]);
            NcbiDatasetProcessor processor = new NcbiDatasetProcessor(inputFile);
            List<File> processedFiles = processor.process(outputDirectory);
            System.out.println("Processed files:");
            for (File file : processedFiles) {
                System.out.println(file.getAbsolutePath());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("Error during processing: " + e.getMessage());
        }
    }
}

